package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DBClusterOptionGroupStatus(
    dbClusterOptionGroupName: scala.Option[String] = None,
    status: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus = {
    import DBClusterOptionGroupStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus
      .builder()
      .optionallyWith(
        dbClusterOptionGroupName.map(value => value: java.lang.String)
      )(_.dbClusterOptionGroupName)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly =
    zio.aws.rds.model.DBClusterOptionGroupStatus.wrap(buildAwsValue())
}
object DBClusterOptionGroupStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterOptionGroupStatus =
      zio.aws.rds.model.DBClusterOptionGroupStatus(
        dbClusterOptionGroupName.map(value => value),
        status.map(value => value)
      )
    def dbClusterOptionGroupName: scala.Option[String]
    def status: scala.Option[String]
    def getDbClusterOptionGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterOptionGroupName", dbClusterOptionGroupName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus
  ) extends zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly {
    override val dbClusterOptionGroupName: scala.Option[String] =
      scala.Option(impl.dbClusterOptionGroupName()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus
  ): zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly = new Wrapper(impl)
}
