package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDbClusterParameterGroupRequest(
    dbClusterParameterGroupName: String,
    dbParameterGroupFamily: String,
    description: String,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest = {
    import CreateDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest
      .builder()
      .dbClusterParameterGroupName(
        dbClusterParameterGroupName: java.lang.String
      )
      .dbParameterGroupFamily(dbParameterGroupFamily: java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.CreateDbClusterParameterGroupRequest.ReadOnly =
    zio.aws.rds.model.CreateDbClusterParameterGroupRequest.wrap(buildAwsValue())
}
object CreateDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbClusterParameterGroupRequest =
      zio.aws.rds.model.CreateDbClusterParameterGroupRequest(
        dbClusterParameterGroupName,
        dbParameterGroupFamily,
        description,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbClusterParameterGroupName: String
    def dbParameterGroupFamily: String
    def description: String
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getDbClusterParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterParameterGroupName)
    def getDbParameterGroupFamily: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbParameterGroupFamily)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest
  ) extends zio.aws.rds.model.CreateDbClusterParameterGroupRequest.ReadOnly {
    override val dbClusterParameterGroupName: String =
      impl.dbClusterParameterGroupName(): String
    override val dbParameterGroupFamily: String =
      impl.dbParameterGroupFamily(): String
    override val description: String = impl.description(): String
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest
  ): zio.aws.rds.model.CreateDbClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
