package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccountQuota(
    accountQuotaName: scala.Option[String] = None,
    used: scala.Option[Long] = None,
    max: scala.Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.AccountQuota = {
    import AccountQuota.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.AccountQuota
      .builder()
      .optionallyWith(accountQuotaName.map(value => value: java.lang.String))(
        _.accountQuotaName
      )
      .optionallyWith(used.map(value => value: java.lang.Long))(_.used)
      .optionallyWith(max.map(value => value: java.lang.Long))(_.max)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.AccountQuota.ReadOnly =
    zio.aws.rds.model.AccountQuota.wrap(buildAwsValue())
}
object AccountQuota {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.AccountQuota] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.AccountQuota =
      zio.aws.rds.model.AccountQuota(
        accountQuotaName.map(value => value),
        used.map(value => value),
        max.map(value => value)
      )
    def accountQuotaName: scala.Option[String]
    def used: scala.Option[Long]
    def max: scala.Option[Long]
    def getAccountQuotaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountQuotaName", accountQuotaName)
    def getUsed: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("used", used)
    def getMax: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.AccountQuota
  ) extends zio.aws.rds.model.AccountQuota.ReadOnly {
    override val accountQuotaName: scala.Option[String] =
      scala.Option(impl.accountQuotaName()).map(value => value: String)
    override val used: scala.Option[Long] =
      scala.Option(impl.used()).map(value => value: Long)
    override val max: scala.Option[Long] =
      scala.Option(impl.max()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.AccountQuota
  ): zio.aws.rds.model.AccountQuota.ReadOnly = new Wrapper(impl)
}
