package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ValidStorageOptions(
    storageType: scala.Option[String] = None,
    storageSize: scala.Option[Iterable[zio.aws.rds.model.Range]] = None,
    provisionedIops: scala.Option[Iterable[zio.aws.rds.model.Range]] = None,
    iopsToStorageRatio: scala.Option[Iterable[zio.aws.rds.model.DoubleRange]] =
      None,
    supportsStorageAutoscaling: scala.Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ValidStorageOptions = {
    import ValidStorageOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ValidStorageOptions
      .builder()
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        storageSize.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageSize)
      .optionallyWith(
        provisionedIops.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedIops)
      .optionallyWith(
        iopsToStorageRatio.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.iopsToStorageRatio)
      .optionallyWith(
        supportsStorageAutoscaling.map(value => value: java.lang.Boolean)
      )(_.supportsStorageAutoscaling)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ValidStorageOptions.ReadOnly =
    zio.aws.rds.model.ValidStorageOptions.wrap(buildAwsValue())
}
object ValidStorageOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ValidStorageOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ValidStorageOptions =
      zio.aws.rds.model.ValidStorageOptions(
        storageType.map(value => value),
        storageSize.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisionedIops.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        iopsToStorageRatio.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportsStorageAutoscaling.map(value => value)
      )
    def storageType: scala.Option[String]
    def storageSize: scala.Option[List[zio.aws.rds.model.Range.ReadOnly]]
    def provisionedIops: scala.Option[List[zio.aws.rds.model.Range.ReadOnly]]
    def iopsToStorageRatio
        : scala.Option[List[zio.aws.rds.model.DoubleRange.ReadOnly]]
    def supportsStorageAutoscaling: scala.Option[Boolean]
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getStorageSize
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("storageSize", storageSize)
    def getProvisionedIops
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("provisionedIops", provisionedIops)
    def getIopsToStorageRatio
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DoubleRange.ReadOnly]] =
      AwsError.unwrapOptionField("iopsToStorageRatio", iopsToStorageRatio)
    def getSupportsStorageAutoscaling: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsStorageAutoscaling",
        supportsStorageAutoscaling
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ValidStorageOptions
  ) extends zio.aws.rds.model.ValidStorageOptions.ReadOnly {
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val storageSize
        : scala.Option[List[zio.aws.rds.model.Range.ReadOnly]] = scala
      .Option(impl.storageSize())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Range.wrap(item)
        }.toList
      )
    override val provisionedIops
        : scala.Option[List[zio.aws.rds.model.Range.ReadOnly]] = scala
      .Option(impl.provisionedIops())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Range.wrap(item)
        }.toList
      )
    override val iopsToStorageRatio
        : scala.Option[List[zio.aws.rds.model.DoubleRange.ReadOnly]] = scala
      .Option(impl.iopsToStorageRatio())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DoubleRange.wrap(item)
        }.toList
      )
    override val supportsStorageAutoscaling: scala.Option[Boolean] = scala
      .Option(impl.supportsStorageAutoscaling())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ValidStorageOptions
  ): zio.aws.rds.model.ValidStorageOptions.ReadOnly = new Wrapper(impl)
}
