package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait TargetRole {
  def unwrap: software.amazon.awssdk.services.rds.model.TargetRole
}
object TargetRole {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.TargetRole
  ): zio.aws.rds.model.TargetRole = value match {
    case software.amazon.awssdk.services.rds.model.TargetRole.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.TargetRole.READ_WRITE =>
      val r = READ_WRITE
      r
    case software.amazon.awssdk.services.rds.model.TargetRole.READ_ONLY =>
      val r = READ_ONLY
      r
    case software.amazon.awssdk.services.rds.model.TargetRole.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.TargetRole {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetRole =
      software.amazon.awssdk.services.rds.model.TargetRole.UNKNOWN_TO_SDK_VERSION
  }
  case object READ_WRITE extends zio.aws.rds.model.TargetRole {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetRole =
      software.amazon.awssdk.services.rds.model.TargetRole.READ_WRITE
  }
  case object READ_ONLY extends zio.aws.rds.model.TargetRole {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetRole =
      software.amazon.awssdk.services.rds.model.TargetRole.READ_ONLY
  }
  case object UNKNOWN extends zio.aws.rds.model.TargetRole {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetRole =
      software.amazon.awssdk.services.rds.model.TargetRole.UNKNOWN
  }
}
