package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopDbClusterRequest(dbClusterIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StopDbClusterRequest = {
    import StopDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StopDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StopDbClusterRequest.ReadOnly =
    zio.aws.rds.model.StopDbClusterRequest.wrap(buildAwsValue())
}
object StopDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StopDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StopDbClusterRequest =
      zio.aws.rds.model.StopDbClusterRequest(dbClusterIdentifier)
    def dbClusterIdentifier: String
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StopDbClusterRequest
  ) extends zio.aws.rds.model.StopDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StopDbClusterRequest
  ): zio.aws.rds.model.StopDbClusterRequest.ReadOnly = new Wrapper(impl)
}
