package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreDbInstanceFromS3Response(
    dbInstance: scala.Option[zio.aws.rds.model.DBInstance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Response = {
    import RestoreDbInstanceFromS3Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Response
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RestoreDbInstanceFromS3Response.ReadOnly =
    zio.aws.rds.model.RestoreDbInstanceFromS3Response.wrap(buildAwsValue())
}
object RestoreDbInstanceFromS3Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbInstanceFromS3Response =
      zio.aws.rds.model.RestoreDbInstanceFromS3Response(
        dbInstance.map(value => value.asEditable)
      )
    def dbInstance: scala.Option[zio.aws.rds.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Response
  ) extends zio.aws.rds.model.RestoreDbInstanceFromS3Response.ReadOnly {
    override val dbInstance
        : scala.Option[zio.aws.rds.model.DBInstance.ReadOnly] = scala
      .Option(impl.dbInstance())
      .map(value => zio.aws.rds.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Response
  ): zio.aws.rds.model.RestoreDbInstanceFromS3Response.ReadOnly = new Wrapper(
    impl
  )
}
