package zio.aws.rds.model
import zio.aws.rds.model.primitives.{IntegerOptional, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Range(
    from: scala.Option[Integer] = None,
    to: scala.Option[Integer] = None,
    step: scala.Option[IntegerOptional] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Range = {
    import Range.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Range
      .builder()
      .optionallyWith(
        from.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.from)
      .optionallyWith(
        to.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.to)
      .optionallyWith(
        step.map(value => IntegerOptional.unwrap(value): java.lang.Integer)
      )(_.step)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Range.ReadOnly =
    zio.aws.rds.model.Range.wrap(buildAwsValue())
}
object Range {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Range] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Range = zio.aws.rds.model.Range(
      from.map(value => value),
      to.map(value => value),
      step.map(value => value)
    )
    def from: scala.Option[Integer]
    def to: scala.Option[Integer]
    def step: scala.Option[IntegerOptional]
    def getFrom: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("from", from)
    def getTo: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("to", to)
    def getStep: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("step", step)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Range
  ) extends zio.aws.rds.model.Range.ReadOnly {
    override val from: scala.Option[Integer] = scala
      .Option(impl.from())
      .map(value => zio.aws.rds.model.primitives.Integer(value))
    override val to: scala.Option[Integer] = scala
      .Option(impl.to())
      .map(value => zio.aws.rds.model.primitives.Integer(value))
    override val step: scala.Option[IntegerOptional] = scala
      .Option(impl.step())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Range
  ): zio.aws.rds.model.Range.ReadOnly = new Wrapper(impl)
}
