package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PromoteReadReplicaRequest(
    dbInstanceIdentifier: String,
    backupRetentionPeriod: scala.Option[IntegerOptional] = None,
    preferredBackupWindow: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest = {
    import PromoteReadReplicaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(
        backupRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.backupRetentionPeriod)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.PromoteReadReplicaRequest.ReadOnly =
    zio.aws.rds.model.PromoteReadReplicaRequest.wrap(buildAwsValue())
}
object PromoteReadReplicaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.PromoteReadReplicaRequest =
      zio.aws.rds.model.PromoteReadReplicaRequest(
        dbInstanceIdentifier,
        backupRetentionPeriod.map(value => value),
        preferredBackupWindow.map(value => value)
      )
    def dbInstanceIdentifier: String
    def backupRetentionPeriod: scala.Option[IntegerOptional]
    def preferredBackupWindow: scala.Option[String]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest
  ) extends zio.aws.rds.model.PromoteReadReplicaRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val backupRetentionPeriod: scala.Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val preferredBackupWindow: scala.Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest
  ): zio.aws.rds.model.PromoteReadReplicaRequest.ReadOnly = new Wrapper(impl)
}
