package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PromoteReadReplicaDbClusterResponse(
    dbCluster: scala.Option[zio.aws.rds.model.DBCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterResponse = {
    import PromoteReadReplicaDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.PromoteReadReplicaDbClusterResponse.ReadOnly =
    zio.aws.rds.model.PromoteReadReplicaDbClusterResponse.wrap(buildAwsValue())
}
object PromoteReadReplicaDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.PromoteReadReplicaDbClusterResponse =
      zio.aws.rds.model.PromoteReadReplicaDbClusterResponse(
        dbCluster.map(value => value.asEditable)
      )
    def dbCluster: scala.Option[zio.aws.rds.model.DBCluster.ReadOnly]
    def getDbCluster: ZIO[Any, AwsError, zio.aws.rds.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterResponse
  ) extends zio.aws.rds.model.PromoteReadReplicaDbClusterResponse.ReadOnly {
    override val dbCluster: scala.Option[zio.aws.rds.model.DBCluster.ReadOnly] =
      scala
        .Option(impl.dbCluster())
        .map(value => zio.aws.rds.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterResponse
  ): zio.aws.rds.model.PromoteReadReplicaDbClusterResponse.ReadOnly =
    new Wrapper(impl)
}
