package zio.aws.rds.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{TStamp, BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PendingModifiedValues(
    dbInstanceClass: scala.Option[String] = None,
    allocatedStorage: scala.Option[IntegerOptional] = None,
    masterUserPassword: scala.Option[String] = None,
    port: scala.Option[IntegerOptional] = None,
    backupRetentionPeriod: scala.Option[IntegerOptional] = None,
    multiAZ: scala.Option[BooleanOptional] = None,
    engineVersion: scala.Option[String] = None,
    licenseModel: scala.Option[String] = None,
    iops: scala.Option[IntegerOptional] = None,
    dbInstanceIdentifier: scala.Option[String] = None,
    storageType: scala.Option[String] = None,
    caCertificateIdentifier: scala.Option[String] = None,
    dbSubnetGroupName: scala.Option[String] = None,
    pendingCloudwatchLogsExports: scala.Option[
      zio.aws.rds.model.PendingCloudwatchLogsExports
    ] = None,
    processorFeatures: scala.Option[Iterable[
      zio.aws.rds.model.ProcessorFeature
    ]] = None,
    iamDatabaseAuthenticationEnabled: scala.Option[BooleanOptional] = None,
    automationMode: scala.Option[zio.aws.rds.model.AutomationMode] = None,
    resumeFullAutomationModeTime: scala.Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PendingModifiedValues = {
    import PendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PendingModifiedValues
      .builder()
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(
        allocatedStorage.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.allocatedStorage)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(
        backupRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.backupRetentionPeriod)
      .optionallyWith(
        multiAZ.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(
        iops.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.iops)
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        pendingCloudwatchLogsExports.map(value => value.buildAwsValue())
      )(_.pendingCloudwatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(automationMode.map(value => value.unwrap))(
        _.automationMode
      )
      .optionallyWith(
        resumeFullAutomationModeTime.map(value => TStamp.unwrap(value): Instant)
      )(_.resumeFullAutomationModeTime)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.PendingModifiedValues.ReadOnly =
    zio.aws.rds.model.PendingModifiedValues.wrap(buildAwsValue())
}
object PendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.PendingModifiedValues =
      zio.aws.rds.model.PendingModifiedValues(
        dbInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        masterUserPassword.map(value => value),
        port.map(value => value),
        backupRetentionPeriod.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        dbInstanceIdentifier.map(value => value),
        storageType.map(value => value),
        caCertificateIdentifier.map(value => value),
        dbSubnetGroupName.map(value => value),
        pendingCloudwatchLogsExports.map(value => value.asEditable),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        iamDatabaseAuthenticationEnabled.map(value => value),
        automationMode.map(value => value),
        resumeFullAutomationModeTime.map(value => value)
      )
    def dbInstanceClass: scala.Option[String]
    def allocatedStorage: scala.Option[IntegerOptional]
    def masterUserPassword: scala.Option[String]
    def port: scala.Option[IntegerOptional]
    def backupRetentionPeriod: scala.Option[IntegerOptional]
    def multiAZ: scala.Option[BooleanOptional]
    def engineVersion: scala.Option[String]
    def licenseModel: scala.Option[String]
    def iops: scala.Option[IntegerOptional]
    def dbInstanceIdentifier: scala.Option[String]
    def storageType: scala.Option[String]
    def caCertificateIdentifier: scala.Option[String]
    def dbSubnetGroupName: scala.Option[String]
    def pendingCloudwatchLogsExports
        : scala.Option[zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly]
    def processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def iamDatabaseAuthenticationEnabled: scala.Option[BooleanOptional]
    def automationMode: scala.Option[zio.aws.rds.model.AutomationMode]
    def resumeFullAutomationModeTime: scala.Option[TStamp]
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getPendingCloudwatchLogsExports: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pendingCloudwatchLogsExports",
      pendingCloudwatchLogsExports
    )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getIamDatabaseAuthenticationEnabled
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "iamDatabaseAuthenticationEnabled",
      iamDatabaseAuthenticationEnabled
    )
    def getAutomationMode
        : ZIO[Any, AwsError, zio.aws.rds.model.AutomationMode] =
      AwsError.unwrapOptionField("automationMode", automationMode)
    def getResumeFullAutomationModeTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "resumeFullAutomationModeTime",
        resumeFullAutomationModeTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PendingModifiedValues
  ) extends zio.aws.rds.model.PendingModifiedValues.ReadOnly {
    override val dbInstanceClass: scala.Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val allocatedStorage: scala.Option[IntegerOptional] = scala
      .Option(impl.allocatedStorage())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val masterUserPassword: scala.Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override val port: scala.Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val backupRetentionPeriod: scala.Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val multiAZ: scala.Option[BooleanOptional] = scala
      .Option(impl.multiAZ())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val licenseModel: scala.Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val iops: scala.Option[IntegerOptional] = scala
      .Option(impl.iops())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val dbInstanceIdentifier: scala.Option[String] =
      scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val caCertificateIdentifier: scala.Option[String] =
      scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
    override val dbSubnetGroupName: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val pendingCloudwatchLogsExports: scala.Option[
      zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly
    ] = scala
      .Option(impl.pendingCloudwatchLogsExports())
      .map(value => zio.aws.rds.model.PendingCloudwatchLogsExports.wrap(value))
    override val processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      scala
        .Option(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val iamDatabaseAuthenticationEnabled
        : scala.Option[BooleanOptional] = scala
      .Option(impl.iamDatabaseAuthenticationEnabled())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val automationMode
        : scala.Option[zio.aws.rds.model.AutomationMode] = scala
      .Option(impl.automationMode())
      .map(value => zio.aws.rds.model.AutomationMode.wrap(value))
    override val resumeFullAutomationModeTime: scala.Option[TStamp] = scala
      .Option(impl.resumeFullAutomationModeTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PendingModifiedValues
  ): zio.aws.rds.model.PendingModifiedValues.ReadOnly = new Wrapper(impl)
}
