package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyEventSubscriptionResponse(
    eventSubscription: scala.Option[zio.aws.rds.model.EventSubscription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse = {
    import ModifyEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyEventSubscriptionResponse.ReadOnly =
    zio.aws.rds.model.ModifyEventSubscriptionResponse.wrap(buildAwsValue())
}
object ModifyEventSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyEventSubscriptionResponse =
      zio.aws.rds.model.ModifyEventSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : scala.Option[zio.aws.rds.model.EventSubscription.ReadOnly]
    def getEventSubscription
        : ZIO[Any, AwsError, zio.aws.rds.model.EventSubscription.ReadOnly] =
      AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse
  ) extends zio.aws.rds.model.ModifyEventSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : scala.Option[zio.aws.rds.model.EventSubscription.ReadOnly] = scala
      .Option(impl.eventSubscription())
      .map(value => zio.aws.rds.model.EventSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse
  ): zio.aws.rds.model.ModifyEventSubscriptionResponse.ReadOnly = new Wrapper(
    impl
  )
}
