package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GlobalCluster(
    globalClusterIdentifier: scala.Option[String] = None,
    globalClusterResourceId: scala.Option[String] = None,
    globalClusterArn: scala.Option[String] = None,
    status: scala.Option[String] = None,
    engine: scala.Option[String] = None,
    engineVersion: scala.Option[String] = None,
    databaseName: scala.Option[String] = None,
    storageEncrypted: scala.Option[BooleanOptional] = None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    globalClusterMembers: scala.Option[Iterable[
      zio.aws.rds.model.GlobalClusterMember
    ]] = None,
    failoverState: scala.Option[zio.aws.rds.model.FailoverState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.GlobalCluster = {
    import GlobalCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.GlobalCluster
      .builder()
      .optionallyWith(
        globalClusterIdentifier.map(value => value: java.lang.String)
      )(_.globalClusterIdentifier)
      .optionallyWith(
        globalClusterResourceId.map(value => value: java.lang.String)
      )(_.globalClusterResourceId)
      .optionallyWith(globalClusterArn.map(value => value: java.lang.String))(
        _.globalClusterArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        storageEncrypted.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.storageEncrypted)
      .optionallyWith(
        deletionProtection.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(
        globalClusterMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalClusterMembers)
      .optionallyWith(failoverState.map(value => value.buildAwsValue()))(
        _.failoverState
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.GlobalCluster.ReadOnly =
    zio.aws.rds.model.GlobalCluster.wrap(buildAwsValue())
}
object GlobalCluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.GlobalCluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.GlobalCluster =
      zio.aws.rds.model.GlobalCluster(
        globalClusterIdentifier.map(value => value),
        globalClusterResourceId.map(value => value),
        globalClusterArn.map(value => value),
        status.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        databaseName.map(value => value),
        storageEncrypted.map(value => value),
        deletionProtection.map(value => value),
        globalClusterMembers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failoverState.map(value => value.asEditable)
      )
    def globalClusterIdentifier: scala.Option[String]
    def globalClusterResourceId: scala.Option[String]
    def globalClusterArn: scala.Option[String]
    def status: scala.Option[String]
    def engine: scala.Option[String]
    def engineVersion: scala.Option[String]
    def databaseName: scala.Option[String]
    def storageEncrypted: scala.Option[BooleanOptional]
    def deletionProtection: scala.Option[BooleanOptional]
    def globalClusterMembers
        : scala.Option[List[zio.aws.rds.model.GlobalClusterMember.ReadOnly]]
    def failoverState: scala.Option[zio.aws.rds.model.FailoverState.ReadOnly]
    def getGlobalClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getGlobalClusterResourceId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterResourceId", globalClusterResourceId)
    def getGlobalClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("globalClusterArn", globalClusterArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getGlobalClusterMembers: ZIO[Any, AwsError, List[
      zio.aws.rds.model.GlobalClusterMember.ReadOnly
    ]] =
      AwsError.unwrapOptionField("globalClusterMembers", globalClusterMembers)
    def getFailoverState
        : ZIO[Any, AwsError, zio.aws.rds.model.FailoverState.ReadOnly] =
      AwsError.unwrapOptionField("failoverState", failoverState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.GlobalCluster
  ) extends zio.aws.rds.model.GlobalCluster.ReadOnly {
    override val globalClusterIdentifier: scala.Option[String] =
      scala.Option(impl.globalClusterIdentifier()).map(value => value: String)
    override val globalClusterResourceId: scala.Option[String] =
      scala.Option(impl.globalClusterResourceId()).map(value => value: String)
    override val globalClusterArn: scala.Option[String] =
      scala.Option(impl.globalClusterArn()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val databaseName: scala.Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val storageEncrypted: scala.Option[BooleanOptional] = scala
      .Option(impl.storageEncrypted())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val globalClusterMembers
        : scala.Option[List[zio.aws.rds.model.GlobalClusterMember.ReadOnly]] =
      scala
        .Option(impl.globalClusterMembers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.GlobalClusterMember.wrap(item)
          }.toList
        )
    override val failoverState
        : scala.Option[zio.aws.rds.model.FailoverState.ReadOnly] = scala
      .Option(impl.failoverState())
      .map(value => zio.aws.rds.model.FailoverState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.GlobalCluster
  ): zio.aws.rds.model.GlobalCluster.ReadOnly = new Wrapper(impl)
}
