package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EventSubscription(
    customerAwsId: scala.Option[String] = None,
    custSubscriptionId: scala.Option[String] = None,
    snsTopicArn: scala.Option[String] = None,
    status: scala.Option[String] = None,
    subscriptionCreationTime: scala.Option[String] = None,
    sourceType: scala.Option[String] = None,
    sourceIdsList: scala.Option[Iterable[String]] = None,
    eventCategoriesList: scala.Option[Iterable[String]] = None,
    enabled: scala.Option[Boolean] = None,
    eventSubscriptionArn: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.EventSubscription = {
    import EventSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.EventSubscription
      .builder()
      .optionallyWith(customerAwsId.map(value => value: java.lang.String))(
        _.customerAwsId
      )
      .optionallyWith(custSubscriptionId.map(value => value: java.lang.String))(
        _.custSubscriptionId
      )
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        subscriptionCreationTime.map(value => value: java.lang.String)
      )(_.subscriptionCreationTime)
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        sourceIdsList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceIdsList)
      .optionallyWith(
        eventCategoriesList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategoriesList)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        eventSubscriptionArn.map(value => value: java.lang.String)
      )(_.eventSubscriptionArn)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.EventSubscription.ReadOnly =
    zio.aws.rds.model.EventSubscription.wrap(buildAwsValue())
}
object EventSubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.EventSubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.EventSubscription =
      zio.aws.rds.model.EventSubscription(
        customerAwsId.map(value => value),
        custSubscriptionId.map(value => value),
        snsTopicArn.map(value => value),
        status.map(value => value),
        subscriptionCreationTime.map(value => value),
        sourceType.map(value => value),
        sourceIdsList.map(value => value),
        eventCategoriesList.map(value => value),
        enabled.map(value => value),
        eventSubscriptionArn.map(value => value)
      )
    def customerAwsId: scala.Option[String]
    def custSubscriptionId: scala.Option[String]
    def snsTopicArn: scala.Option[String]
    def status: scala.Option[String]
    def subscriptionCreationTime: scala.Option[String]
    def sourceType: scala.Option[String]
    def sourceIdsList: scala.Option[List[String]]
    def eventCategoriesList: scala.Option[List[String]]
    def enabled: scala.Option[Boolean]
    def eventSubscriptionArn: scala.Option[String]
    def getCustomerAwsId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerAwsId", customerAwsId)
    def getCustSubscriptionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("custSubscriptionId", custSubscriptionId)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSubscriptionCreationTime: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("subscriptionCreationTime", subscriptionCreationTime)
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceIdsList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceIdsList", sourceIdsList)
    def getEventCategoriesList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategoriesList", eventCategoriesList)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getEventSubscriptionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventSubscriptionArn", eventSubscriptionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.EventSubscription
  ) extends zio.aws.rds.model.EventSubscription.ReadOnly {
    override val customerAwsId: scala.Option[String] =
      scala.Option(impl.customerAwsId()).map(value => value: String)
    override val custSubscriptionId: scala.Option[String] =
      scala.Option(impl.custSubscriptionId()).map(value => value: String)
    override val snsTopicArn: scala.Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val subscriptionCreationTime: scala.Option[String] =
      scala.Option(impl.subscriptionCreationTime()).map(value => value: String)
    override val sourceType: scala.Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val sourceIdsList: scala.Option[List[String]] = scala
      .Option(impl.sourceIdsList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val eventCategoriesList: scala.Option[List[String]] = scala
      .Option(impl.eventCategoriesList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val enabled: scala.Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val eventSubscriptionArn: scala.Option[String] =
      scala.Option(impl.eventSubscriptionArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.EventSubscription
  ): zio.aws.rds.model.EventSubscription.ReadOnly = new Wrapper(impl)
}
