package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeOptionGroupOptionsResponse(
    optionGroupOptions: scala.Option[Iterable[
      zio.aws.rds.model.OptionGroupOption
    ]] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse = {
    import DescribeOptionGroupOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse
      .builder()
      .optionallyWith(
        optionGroupOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupOptions)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeOptionGroupOptionsResponse.ReadOnly =
    zio.aws.rds.model.DescribeOptionGroupOptionsResponse.wrap(buildAwsValue())
}
object DescribeOptionGroupOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeOptionGroupOptionsResponse =
      zio.aws.rds.model.DescribeOptionGroupOptionsResponse(
        optionGroupOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def optionGroupOptions
        : scala.Option[List[zio.aws.rds.model.OptionGroupOption.ReadOnly]]
    def marker: scala.Option[String]
    def getOptionGroupOptions: ZIO[Any, AwsError, List[
      zio.aws.rds.model.OptionGroupOption.ReadOnly
    ]] = AwsError.unwrapOptionField("optionGroupOptions", optionGroupOptions)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse
  ) extends zio.aws.rds.model.DescribeOptionGroupOptionsResponse.ReadOnly {
    override val optionGroupOptions
        : scala.Option[List[zio.aws.rds.model.OptionGroupOption.ReadOnly]] =
      scala
        .Option(impl.optionGroupOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.OptionGroupOption.wrap(item)
          }.toList
        )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse
  ): zio.aws.rds.model.DescribeOptionGroupOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
