package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbSnapshotsResponse(
    marker: scala.Option[String] = None,
    dbSnapshots: scala.Option[Iterable[zio.aws.rds.model.DBSnapshot]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse = {
    import DescribeDbSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbSnapshots)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbSnapshotsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbSnapshotsResponse.wrap(buildAwsValue())
}
object DescribeDbSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbSnapshotsResponse =
      zio.aws.rds.model.DescribeDbSnapshotsResponse(
        marker.map(value => value),
        dbSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: scala.Option[String]
    def dbSnapshots: scala.Option[List[zio.aws.rds.model.DBSnapshot.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbSnapshots
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBSnapshot.ReadOnly]] =
      AwsError.unwrapOptionField("dbSnapshots", dbSnapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse
  ) extends zio.aws.rds.model.DescribeDbSnapshotsResponse.ReadOnly {
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val dbSnapshots
        : scala.Option[List[zio.aws.rds.model.DBSnapshot.ReadOnly]] = scala
      .Option(impl.dbSnapshots())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBSnapshot.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse
  ): zio.aws.rds.model.DescribeDbSnapshotsResponse.ReadOnly = new Wrapper(impl)
}
