package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDbSnapshotAttributesRequest(
    dbSnapshotIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest = {
    import DescribeDbSnapshotAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest
      .builder()
      .dbSnapshotIdentifier(dbSnapshotIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbSnapshotAttributesRequest.ReadOnly =
    zio.aws.rds.model.DescribeDbSnapshotAttributesRequest.wrap(buildAwsValue())
}
object DescribeDbSnapshotAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbSnapshotAttributesRequest =
      zio.aws.rds.model
        .DescribeDbSnapshotAttributesRequest(dbSnapshotIdentifier)
    def dbSnapshotIdentifier: String
    def getDbSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSnapshotIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest
  ) extends zio.aws.rds.model.DescribeDbSnapshotAttributesRequest.ReadOnly {
    override val dbSnapshotIdentifier: String =
      impl.dbSnapshotIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest
  ): zio.aws.rds.model.DescribeDbSnapshotAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
