package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbEngineVersionsRequest(
    engine: scala.Option[String] = None,
    engineVersion: scala.Option[String] = None,
    dbParameterGroupFamily: scala.Option[String] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None,
    maxRecords: scala.Option[IntegerOptional] = None,
    marker: scala.Option[String] = None,
    defaultOnly: scala.Option[Boolean] = None,
    listSupportedCharacterSets: scala.Option[BooleanOptional] = None,
    listSupportedTimezones: scala.Option[BooleanOptional] = None,
    includeAll: scala.Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest = {
    import DescribeDbEngineVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(defaultOnly.map(value => value: java.lang.Boolean))(
        _.defaultOnly
      )
      .optionallyWith(
        listSupportedCharacterSets.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.listSupportedCharacterSets)
      .optionallyWith(
        listSupportedTimezones.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.listSupportedTimezones)
      .optionallyWith(
        includeAll.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.includeAll)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbEngineVersionsRequest.ReadOnly =
    zio.aws.rds.model.DescribeDbEngineVersionsRequest.wrap(buildAwsValue())
}
object DescribeDbEngineVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbEngineVersionsRequest =
      zio.aws.rds.model.DescribeDbEngineVersionsRequest(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbParameterGroupFamily.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value),
        defaultOnly.map(value => value),
        listSupportedCharacterSets.map(value => value),
        listSupportedTimezones.map(value => value),
        includeAll.map(value => value)
      )
    def engine: scala.Option[String]
    def engineVersion: scala.Option[String]
    def dbParameterGroupFamily: scala.Option[String]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: scala.Option[IntegerOptional]
    def marker: scala.Option[String]
    def defaultOnly: scala.Option[Boolean]
    def listSupportedCharacterSets: scala.Option[BooleanOptional]
    def listSupportedTimezones: scala.Option[BooleanOptional]
    def includeAll: scala.Option[BooleanOptional]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDefaultOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultOnly", defaultOnly)
    def getListSupportedCharacterSets: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "listSupportedCharacterSets",
        listSupportedCharacterSets
      )
    def getListSupportedTimezones: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "listSupportedTimezones",
        listSupportedTimezones
      )
    def getIncludeAll: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includeAll", includeAll)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest
  ) extends zio.aws.rds.model.DescribeDbEngineVersionsRequest.ReadOnly {
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val dbParameterGroupFamily: scala.Option[String] =
      scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: scala.Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val defaultOnly: scala.Option[Boolean] =
      scala.Option(impl.defaultOnly()).map(value => value: Boolean)
    override val listSupportedCharacterSets: scala.Option[BooleanOptional] =
      scala
        .Option(impl.listSupportedCharacterSets())
        .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val listSupportedTimezones: scala.Option[BooleanOptional] = scala
      .Option(impl.listSupportedTimezones())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val includeAll: scala.Option[BooleanOptional] = scala
      .Option(impl.includeAll())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest
  ): zio.aws.rds.model.DescribeDbEngineVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
