package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDBLogFilesDetails(
    logFileName: scala.Option[String] = None,
    lastWritten: scala.Option[Long] = None,
    size: scala.Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails = {
    import DescribeDBLogFilesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails
      .builder()
      .optionallyWith(logFileName.map(value => value: java.lang.String))(
        _.logFileName
      )
      .optionallyWith(lastWritten.map(value => value: java.lang.Long))(
        _.lastWritten
      )
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly =
    zio.aws.rds.model.DescribeDBLogFilesDetails.wrap(buildAwsValue())
}
object DescribeDBLogFilesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDBLogFilesDetails =
      zio.aws.rds.model.DescribeDBLogFilesDetails(
        logFileName.map(value => value),
        lastWritten.map(value => value),
        size.map(value => value)
      )
    def logFileName: scala.Option[String]
    def lastWritten: scala.Option[Long]
    def size: scala.Option[Long]
    def getLogFileName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logFileName", logFileName)
    def getLastWritten: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lastWritten", lastWritten)
    def getSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails
  ) extends zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly {
    override val logFileName: scala.Option[String] =
      scala.Option(impl.logFileName()).map(value => value: String)
    override val lastWritten: scala.Option[Long] =
      scala.Option(impl.lastWritten()).map(value => value: Long)
    override val size: scala.Option[Long] =
      scala.Option(impl.size()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails
  ): zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly = new Wrapper(impl)
}
