package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DBSecurityGroupMembership(
    dbSecurityGroupName: scala.Option[String] = None,
    status: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership = {
    import DBSecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership
      .builder()
      .optionallyWith(
        dbSecurityGroupName.map(value => value: java.lang.String)
      )(_.dbSecurityGroupName)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly =
    zio.aws.rds.model.DBSecurityGroupMembership.wrap(buildAwsValue())
}
object DBSecurityGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBSecurityGroupMembership =
      zio.aws.rds.model.DBSecurityGroupMembership(
        dbSecurityGroupName.map(value => value),
        status.map(value => value)
      )
    def dbSecurityGroupName: scala.Option[String]
    def status: scala.Option[String]
    def getDbSecurityGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSecurityGroupName", dbSecurityGroupName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership
  ) extends zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly {
    override val dbSecurityGroupName: scala.Option[String] =
      scala.Option(impl.dbSecurityGroupName()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership
  ): zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly = new Wrapper(impl)
}
