package zio.aws.rds.model
import zio.aws.rds.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DBEngineVersion(
    engine: scala.Option[String] = None,
    engineVersion: scala.Option[String] = None,
    dbParameterGroupFamily: scala.Option[String] = None,
    dbEngineDescription: scala.Option[String] = None,
    dbEngineVersionDescription: scala.Option[String] = None,
    defaultCharacterSet: scala.Option[zio.aws.rds.model.CharacterSet] = None,
    supportedCharacterSets: scala.Option[Iterable[
      zio.aws.rds.model.CharacterSet
    ]] = None,
    supportedNcharCharacterSets: scala.Option[Iterable[
      zio.aws.rds.model.CharacterSet
    ]] = None,
    validUpgradeTarget: scala.Option[Iterable[
      zio.aws.rds.model.UpgradeTarget
    ]] = None,
    supportedTimezones: scala.Option[Iterable[zio.aws.rds.model.Timezone]] =
      None,
    exportableLogTypes: scala.Option[Iterable[String]] = None,
    supportsLogExportsToCloudwatchLogs: scala.Option[Boolean] = None,
    supportsReadReplica: scala.Option[Boolean] = None,
    supportedEngineModes: scala.Option[Iterable[String]] = None,
    supportedFeatureNames: scala.Option[Iterable[String]] = None,
    status: scala.Option[String] = None,
    supportsParallelQuery: scala.Option[Boolean] = None,
    supportsGlobalDatabases: scala.Option[Boolean] = None,
    majorEngineVersion: scala.Option[String] = None,
    databaseInstallationFilesS3BucketName: scala.Option[String] = None,
    databaseInstallationFilesS3Prefix: scala.Option[String] = None,
    dbEngineVersionArn: scala.Option[String] = None,
    kmsKeyId: scala.Option[String] = None,
    createTime: scala.Option[TStamp] = None,
    tagList: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBEngineVersion = {
    import DBEngineVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBEngineVersion
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(
        dbEngineDescription.map(value => value: java.lang.String)
      )(_.dbEngineDescription)
      .optionallyWith(
        dbEngineVersionDescription.map(value => value: java.lang.String)
      )(_.dbEngineVersionDescription)
      .optionallyWith(defaultCharacterSet.map(value => value.buildAwsValue()))(
        _.defaultCharacterSet
      )
      .optionallyWith(
        supportedCharacterSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedCharacterSets)
      .optionallyWith(
        supportedNcharCharacterSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedNcharCharacterSets)
      .optionallyWith(
        validUpgradeTarget.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validUpgradeTarget)
      .optionallyWith(
        supportedTimezones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedTimezones)
      .optionallyWith(
        exportableLogTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exportableLogTypes)
      .optionallyWith(
        supportsLogExportsToCloudwatchLogs.map(value =>
          value: java.lang.Boolean
        )
      )(_.supportsLogExportsToCloudwatchLogs)
      .optionallyWith(
        supportsReadReplica.map(value => value: java.lang.Boolean)
      )(_.supportsReadReplica)
      .optionallyWith(
        supportedEngineModes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedEngineModes)
      .optionallyWith(
        supportedFeatureNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedFeatureNames)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        supportsParallelQuery.map(value => value: java.lang.Boolean)
      )(_.supportsParallelQuery)
      .optionallyWith(
        supportsGlobalDatabases.map(value => value: java.lang.Boolean)
      )(_.supportsGlobalDatabases)
      .optionallyWith(majorEngineVersion.map(value => value: java.lang.String))(
        _.majorEngineVersion
      )
      .optionallyWith(
        databaseInstallationFilesS3BucketName.map(value =>
          value: java.lang.String
        )
      )(_.databaseInstallationFilesS3BucketName)
      .optionallyWith(
        databaseInstallationFilesS3Prefix.map(value => value: java.lang.String)
      )(_.databaseInstallationFilesS3Prefix)
      .optionallyWith(dbEngineVersionArn.map(value => value: java.lang.String))(
        _.dbEngineVersionArn
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(createTime.map(value => TStamp.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBEngineVersion.ReadOnly =
    zio.aws.rds.model.DBEngineVersion.wrap(buildAwsValue())
}
object DBEngineVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBEngineVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBEngineVersion =
      zio.aws.rds.model.DBEngineVersion(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbParameterGroupFamily.map(value => value),
        dbEngineDescription.map(value => value),
        dbEngineVersionDescription.map(value => value),
        defaultCharacterSet.map(value => value.asEditable),
        supportedCharacterSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedNcharCharacterSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        validUpgradeTarget.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedTimezones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        exportableLogTypes.map(value => value),
        supportsLogExportsToCloudwatchLogs.map(value => value),
        supportsReadReplica.map(value => value),
        supportedEngineModes.map(value => value),
        supportedFeatureNames.map(value => value),
        status.map(value => value),
        supportsParallelQuery.map(value => value),
        supportsGlobalDatabases.map(value => value),
        majorEngineVersion.map(value => value),
        databaseInstallationFilesS3BucketName.map(value => value),
        databaseInstallationFilesS3Prefix.map(value => value),
        dbEngineVersionArn.map(value => value),
        kmsKeyId.map(value => value),
        createTime.map(value => value),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def engine: scala.Option[String]
    def engineVersion: scala.Option[String]
    def dbParameterGroupFamily: scala.Option[String]
    def dbEngineDescription: scala.Option[String]
    def dbEngineVersionDescription: scala.Option[String]
    def defaultCharacterSet
        : scala.Option[zio.aws.rds.model.CharacterSet.ReadOnly]
    def supportedCharacterSets
        : scala.Option[List[zio.aws.rds.model.CharacterSet.ReadOnly]]
    def supportedNcharCharacterSets
        : scala.Option[List[zio.aws.rds.model.CharacterSet.ReadOnly]]
    def validUpgradeTarget
        : scala.Option[List[zio.aws.rds.model.UpgradeTarget.ReadOnly]]
    def supportedTimezones
        : scala.Option[List[zio.aws.rds.model.Timezone.ReadOnly]]
    def exportableLogTypes: scala.Option[List[String]]
    def supportsLogExportsToCloudwatchLogs: scala.Option[Boolean]
    def supportsReadReplica: scala.Option[Boolean]
    def supportedEngineModes: scala.Option[List[String]]
    def supportedFeatureNames: scala.Option[List[String]]
    def status: scala.Option[String]
    def supportsParallelQuery: scala.Option[Boolean]
    def supportsGlobalDatabases: scala.Option[Boolean]
    def majorEngineVersion: scala.Option[String]
    def databaseInstallationFilesS3BucketName: scala.Option[String]
    def databaseInstallationFilesS3Prefix: scala.Option[String]
    def dbEngineVersionArn: scala.Option[String]
    def kmsKeyId: scala.Option[String]
    def createTime: scala.Option[TStamp]
    def tagList: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getDbEngineDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbEngineDescription", dbEngineDescription)
    def getDbEngineVersionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbEngineVersionDescription",
        dbEngineVersionDescription
      )
    def getDefaultCharacterSet
        : ZIO[Any, AwsError, zio.aws.rds.model.CharacterSet.ReadOnly] =
      AwsError.unwrapOptionField("defaultCharacterSet", defaultCharacterSet)
    def getSupportedCharacterSets
        : ZIO[Any, AwsError, List[zio.aws.rds.model.CharacterSet.ReadOnly]] =
      AwsError.unwrapOptionField(
        "supportedCharacterSets",
        supportedCharacterSets
      )
    def getSupportedNcharCharacterSets
        : ZIO[Any, AwsError, List[zio.aws.rds.model.CharacterSet.ReadOnly]] =
      AwsError.unwrapOptionField(
        "supportedNcharCharacterSets",
        supportedNcharCharacterSets
      )
    def getValidUpgradeTarget
        : ZIO[Any, AwsError, List[zio.aws.rds.model.UpgradeTarget.ReadOnly]] =
      AwsError.unwrapOptionField("validUpgradeTarget", validUpgradeTarget)
    def getSupportedTimezones
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Timezone.ReadOnly]] =
      AwsError.unwrapOptionField("supportedTimezones", supportedTimezones)
    def getExportableLogTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("exportableLogTypes", exportableLogTypes)
    def getSupportsLogExportsToCloudwatchLogs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsLogExportsToCloudwatchLogs",
        supportsLogExportsToCloudwatchLogs
      )
    def getSupportsReadReplica: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsReadReplica", supportsReadReplica)
    def getSupportedEngineModes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("supportedEngineModes", supportedEngineModes)
    def getSupportedFeatureNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("supportedFeatureNames", supportedFeatureNames)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSupportsParallelQuery: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsParallelQuery", supportsParallelQuery)
    def getSupportsGlobalDatabases: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("supportsGlobalDatabases", supportsGlobalDatabases)
    def getMajorEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("majorEngineVersion", majorEngineVersion)
    def getDatabaseInstallationFilesS3BucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "databaseInstallationFilesS3BucketName",
        databaseInstallationFilesS3BucketName
      )
    def getDatabaseInstallationFilesS3Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "databaseInstallationFilesS3Prefix",
        databaseInstallationFilesS3Prefix
      )
    def getDbEngineVersionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbEngineVersionArn", dbEngineVersionArn)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBEngineVersion
  ) extends zio.aws.rds.model.DBEngineVersion.ReadOnly {
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val dbParameterGroupFamily: scala.Option[String] =
      scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
    override val dbEngineDescription: scala.Option[String] =
      scala.Option(impl.dbEngineDescription()).map(value => value: String)
    override val dbEngineVersionDescription: scala.Option[String] = scala
      .Option(impl.dbEngineVersionDescription())
      .map(value => value: String)
    override val defaultCharacterSet
        : scala.Option[zio.aws.rds.model.CharacterSet.ReadOnly] = scala
      .Option(impl.defaultCharacterSet())
      .map(value => zio.aws.rds.model.CharacterSet.wrap(value))
    override val supportedCharacterSets
        : scala.Option[List[zio.aws.rds.model.CharacterSet.ReadOnly]] = scala
      .Option(impl.supportedCharacterSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.CharacterSet.wrap(item)
        }.toList
      )
    override val supportedNcharCharacterSets
        : scala.Option[List[zio.aws.rds.model.CharacterSet.ReadOnly]] = scala
      .Option(impl.supportedNcharCharacterSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.CharacterSet.wrap(item)
        }.toList
      )
    override val validUpgradeTarget
        : scala.Option[List[zio.aws.rds.model.UpgradeTarget.ReadOnly]] = scala
      .Option(impl.validUpgradeTarget())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.UpgradeTarget.wrap(item)
        }.toList
      )
    override val supportedTimezones
        : scala.Option[List[zio.aws.rds.model.Timezone.ReadOnly]] = scala
      .Option(impl.supportedTimezones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Timezone.wrap(item)
        }.toList
      )
    override val exportableLogTypes: scala.Option[List[String]] = scala
      .Option(impl.exportableLogTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val supportsLogExportsToCloudwatchLogs: scala.Option[Boolean] =
      scala
        .Option(impl.supportsLogExportsToCloudwatchLogs())
        .map(value => value: Boolean)
    override val supportsReadReplica: scala.Option[Boolean] =
      scala.Option(impl.supportsReadReplica()).map(value => value: Boolean)
    override val supportedEngineModes: scala.Option[List[String]] = scala
      .Option(impl.supportedEngineModes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val supportedFeatureNames: scala.Option[List[String]] = scala
      .Option(impl.supportedFeatureNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val supportsParallelQuery: scala.Option[Boolean] =
      scala.Option(impl.supportsParallelQuery()).map(value => value: Boolean)
    override val supportsGlobalDatabases: scala.Option[Boolean] =
      scala.Option(impl.supportsGlobalDatabases()).map(value => value: Boolean)
    override val majorEngineVersion: scala.Option[String] =
      scala.Option(impl.majorEngineVersion()).map(value => value: String)
    override val databaseInstallationFilesS3BucketName: scala.Option[String] =
      scala
        .Option(impl.databaseInstallationFilesS3BucketName())
        .map(value => value: String)
    override val databaseInstallationFilesS3Prefix: scala.Option[String] = scala
      .Option(impl.databaseInstallationFilesS3Prefix())
      .map(value => value: String)
    override val dbEngineVersionArn: scala.Option[String] =
      scala.Option(impl.dbEngineVersionArn()).map(value => value: String)
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val createTime: scala.Option[TStamp] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val tagList: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBEngineVersion
  ): zio.aws.rds.model.DBEngineVersion.ReadOnly = new Wrapper(impl)
}
