package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDbSnapshotResponse(
    dbSnapshot: scala.Option[zio.aws.rds.model.DBSnapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse = {
    import CreateDbSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse
      .builder()
      .optionallyWith(dbSnapshot.map(value => value.buildAwsValue()))(
        _.dbSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbSnapshotResponse.ReadOnly =
    zio.aws.rds.model.CreateDbSnapshotResponse.wrap(buildAwsValue())
}
object CreateDbSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbSnapshotResponse =
      zio.aws.rds.model
        .CreateDbSnapshotResponse(dbSnapshot.map(value => value.asEditable))
    def dbSnapshot: scala.Option[zio.aws.rds.model.DBSnapshot.ReadOnly]
    def getDbSnapshot
        : ZIO[Any, AwsError, zio.aws.rds.model.DBSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbSnapshot", dbSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse
  ) extends zio.aws.rds.model.CreateDbSnapshotResponse.ReadOnly {
    override val dbSnapshot
        : scala.Option[zio.aws.rds.model.DBSnapshot.ReadOnly] = scala
      .Option(impl.dbSnapshot())
      .map(value => zio.aws.rds.model.DBSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse
  ): zio.aws.rds.model.CreateDbSnapshotResponse.ReadOnly = new Wrapper(impl)
}
