package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDbProxyRequest(
    dbProxyName: String,
    engineFamily: zio.aws.rds.model.EngineFamily,
    auth: Iterable[zio.aws.rds.model.UserAuthConfig],
    roleArn: String,
    vpcSubnetIds: Iterable[String],
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    requireTLS: scala.Option[Boolean] = None,
    idleClientTimeout: scala.Option[IntegerOptional] = None,
    debugLogging: scala.Option[Boolean] = None,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbProxyRequest = {
    import CreateDbProxyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbProxyRequest
      .builder()
      .dbProxyName(dbProxyName: java.lang.String)
      .engineFamily(engineFamily.unwrap)
      .auth(auth.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(roleArn: java.lang.String)
      .vpcSubnetIds(vpcSubnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(requireTLS.map(value => value: java.lang.Boolean))(
        _.requireTLS
      )
      .optionallyWith(
        idleClientTimeout.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.idleClientTimeout)
      .optionallyWith(debugLogging.map(value => value: java.lang.Boolean))(
        _.debugLogging
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbProxyRequest.ReadOnly =
    zio.aws.rds.model.CreateDbProxyRequest.wrap(buildAwsValue())
}
object CreateDbProxyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbProxyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbProxyRequest =
      zio.aws.rds.model.CreateDbProxyRequest(
        dbProxyName,
        engineFamily,
        auth.map { item =>
          item.asEditable
        },
        roleArn,
        vpcSubnetIds,
        vpcSecurityGroupIds.map(value => value),
        requireTLS.map(value => value),
        idleClientTimeout.map(value => value),
        debugLogging.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbProxyName: String
    def engineFamily: zio.aws.rds.model.EngineFamily
    def auth: List[zio.aws.rds.model.UserAuthConfig.ReadOnly]
    def roleArn: String
    def vpcSubnetIds: List[String]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def requireTLS: scala.Option[Boolean]
    def idleClientTimeout: scala.Option[IntegerOptional]
    def debugLogging: scala.Option[Boolean]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getDbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyName)
    def getEngineFamily: ZIO[Any, Nothing, zio.aws.rds.model.EngineFamily] =
      ZIO.succeed(engineFamily)
    def getAuth
        : ZIO[Any, Nothing, List[zio.aws.rds.model.UserAuthConfig.ReadOnly]] =
      ZIO.succeed(auth)
    def getRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArn)
    def getVpcSubnetIds: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(vpcSubnetIds)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getRequireTLS: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requireTLS", requireTLS)
    def getIdleClientTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("idleClientTimeout", idleClientTimeout)
    def getDebugLogging: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("debugLogging", debugLogging)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbProxyRequest
  ) extends zio.aws.rds.model.CreateDbProxyRequest.ReadOnly {
    override val dbProxyName: String = impl.dbProxyName(): String
    override val engineFamily: zio.aws.rds.model.EngineFamily =
      zio.aws.rds.model.EngineFamily.wrap(impl.engineFamily())
    override val auth: List[zio.aws.rds.model.UserAuthConfig.ReadOnly] = impl
      .auth()
      .asScala
      .map { item =>
        zio.aws.rds.model.UserAuthConfig.wrap(item)
      }
      .toList
    override val roleArn: String = impl.roleArn(): String
    override val vpcSubnetIds: List[String] = impl
      .vpcSubnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val requireTLS: scala.Option[Boolean] =
      scala.Option(impl.requireTLS()).map(value => value: Boolean)
    override val idleClientTimeout: scala.Option[IntegerOptional] = scala
      .Option(impl.idleClientTimeout())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val debugLogging: scala.Option[Boolean] =
      scala.Option(impl.debugLogging()).map(value => value: Boolean)
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbProxyRequest
  ): zio.aws.rds.model.CreateDbProxyRequest.ReadOnly = new Wrapper(impl)
}
