package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartDbInstanceResponse(
    dbInstance: scala.Option[zio.aws.rds.model.DBInstance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StartDbInstanceResponse = {
    import StartDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StartDbInstanceResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StartDbInstanceResponse.ReadOnly =
    zio.aws.rds.model.StartDbInstanceResponse.wrap(buildAwsValue())
}
object StartDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StartDbInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StartDbInstanceResponse =
      zio.aws.rds.model
        .StartDbInstanceResponse(dbInstance.map(value => value.asEditable))
    def dbInstance: scala.Option[zio.aws.rds.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StartDbInstanceResponse
  ) extends zio.aws.rds.model.StartDbInstanceResponse.ReadOnly {
    override val dbInstance
        : scala.Option[zio.aws.rds.model.DBInstance.ReadOnly] = scala
      .Option(impl.dbInstance())
      .map(value => zio.aws.rds.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StartDbInstanceResponse
  ): zio.aws.rds.model.StartDbInstanceResponse.ReadOnly = new Wrapper(impl)
}
