package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreDbClusterFromSnapshotResponse(
    dbCluster: scala.Option[zio.aws.rds.model.DBCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse = {
    import RestoreDbClusterFromSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.ReadOnly =
    zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.wrap(buildAwsValue())
}
object RestoreDbClusterFromSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse =
      zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse(
        dbCluster.map(value => value.asEditable)
      )
    def dbCluster: scala.Option[zio.aws.rds.model.DBCluster.ReadOnly]
    def getDbCluster: ZIO[Any, AwsError, zio.aws.rds.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse
  ) extends zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.ReadOnly {
    override val dbCluster: scala.Option[zio.aws.rds.model.DBCluster.ReadOnly] =
      scala
        .Option(impl.dbCluster())
        .map(value => zio.aws.rds.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse
  ): zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
