package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RemoveFromGlobalClusterRequest(
    globalClusterIdentifier: scala.Option[String] = None,
    dbClusterIdentifier: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest = {
    import RemoveFromGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest
      .builder()
      .optionallyWith(
        globalClusterIdentifier.map(value => value: java.lang.String)
      )(_.globalClusterIdentifier)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RemoveFromGlobalClusterRequest.ReadOnly =
    zio.aws.rds.model.RemoveFromGlobalClusterRequest.wrap(buildAwsValue())
}
object RemoveFromGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RemoveFromGlobalClusterRequest =
      zio.aws.rds.model.RemoveFromGlobalClusterRequest(
        globalClusterIdentifier.map(value => value),
        dbClusterIdentifier.map(value => value)
      )
    def globalClusterIdentifier: scala.Option[String]
    def dbClusterIdentifier: scala.Option[String]
    def getGlobalClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest
  ) extends zio.aws.rds.model.RemoveFromGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: scala.Option[String] =
      scala.Option(impl.globalClusterIdentifier()).map(value => value: String)
    override val dbClusterIdentifier: scala.Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest
  ): zio.aws.rds.model.RemoveFromGlobalClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
