package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProcessorFeature(
    name: scala.Option[String] = None,
    value: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ProcessorFeature = {
    import ProcessorFeature.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ProcessorFeature
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ProcessorFeature.ReadOnly =
    zio.aws.rds.model.ProcessorFeature.wrap(buildAwsValue())
}
object ProcessorFeature {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ProcessorFeature
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ProcessorFeature = zio.aws.rds.model
      .ProcessorFeature(name.map(value => value), value.map(value => value))
    def name: scala.Option[String]
    def value: scala.Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ProcessorFeature
  ) extends zio.aws.rds.model.ProcessorFeature.ReadOnly {
    override val name: scala.Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val value: scala.Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ProcessorFeature
  ): zio.aws.rds.model.ProcessorFeature.ReadOnly = new Wrapper(impl)
}
