package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Parameter(
    parameterName: scala.Option[String] = None,
    parameterValue: scala.Option[String] = None,
    description: scala.Option[String] = None,
    source: scala.Option[String] = None,
    applyType: scala.Option[String] = None,
    dataType: scala.Option[String] = None,
    allowedValues: scala.Option[String] = None,
    isModifiable: scala.Option[Boolean] = None,
    minimumEngineVersion: scala.Option[String] = None,
    applyMethod: scala.Option[zio.aws.rds.model.ApplyMethod] = None,
    supportedEngineModes: scala.Option[Iterable[String]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Parameter
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(parameterValue.map(value => value: java.lang.String))(
        _.parameterValue
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(applyType.map(value => value: java.lang.String))(
        _.applyType
      )
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(applyMethod.map(value => value.unwrap))(_.applyMethod)
      .optionallyWith(
        supportedEngineModes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedEngineModes)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Parameter.ReadOnly =
    zio.aws.rds.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Parameter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Parameter = zio.aws.rds.model.Parameter(
      parameterName.map(value => value),
      parameterValue.map(value => value),
      description.map(value => value),
      source.map(value => value),
      applyType.map(value => value),
      dataType.map(value => value),
      allowedValues.map(value => value),
      isModifiable.map(value => value),
      minimumEngineVersion.map(value => value),
      applyMethod.map(value => value),
      supportedEngineModes.map(value => value)
    )
    def parameterName: scala.Option[String]
    def parameterValue: scala.Option[String]
    def description: scala.Option[String]
    def source: scala.Option[String]
    def applyType: scala.Option[String]
    def dataType: scala.Option[String]
    def allowedValues: scala.Option[String]
    def isModifiable: scala.Option[Boolean]
    def minimumEngineVersion: scala.Option[String]
    def applyMethod: scala.Option[zio.aws.rds.model.ApplyMethod]
    def supportedEngineModes: scala.Option[List[String]]
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getApplyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyType", applyType)
    def getDataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getApplyMethod: ZIO[Any, AwsError, zio.aws.rds.model.ApplyMethod] =
      AwsError.unwrapOptionField("applyMethod", applyMethod)
    def getSupportedEngineModes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("supportedEngineModes", supportedEngineModes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Parameter
  ) extends zio.aws.rds.model.Parameter.ReadOnly {
    override val parameterName: scala.Option[String] =
      scala.Option(impl.parameterName()).map(value => value: String)
    override val parameterValue: scala.Option[String] =
      scala.Option(impl.parameterValue()).map(value => value: String)
    override val description: scala.Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val source: scala.Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val applyType: scala.Option[String] =
      scala.Option(impl.applyType()).map(value => value: String)
    override val dataType: scala.Option[String] =
      scala.Option(impl.dataType()).map(value => value: String)
    override val allowedValues: scala.Option[String] =
      scala.Option(impl.allowedValues()).map(value => value: String)
    override val isModifiable: scala.Option[Boolean] =
      scala.Option(impl.isModifiable()).map(value => value: Boolean)
    override val minimumEngineVersion: scala.Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
    override val applyMethod: scala.Option[zio.aws.rds.model.ApplyMethod] =
      scala
        .Option(impl.applyMethod())
        .map(value => zio.aws.rds.model.ApplyMethod.wrap(value))
    override val supportedEngineModes: scala.Option[List[String]] = scala
      .Option(impl.supportedEngineModes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Parameter
  ): zio.aws.rds.model.Parameter.ReadOnly = new Wrapper(impl)
}
