package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OptionGroupOptionSetting(
    settingName: scala.Option[String] = None,
    settingDescription: scala.Option[String] = None,
    defaultValue: scala.Option[String] = None,
    applyType: scala.Option[String] = None,
    allowedValues: scala.Option[String] = None,
    isModifiable: scala.Option[Boolean] = None,
    isRequired: scala.Option[Boolean] = None,
    minimumEngineVersionPerAllowedValue: scala.Option[Iterable[
      zio.aws.rds.model.MinimumEngineVersionPerAllowedValue
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting = {
    import OptionGroupOptionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting
      .builder()
      .optionallyWith(settingName.map(value => value: java.lang.String))(
        _.settingName
      )
      .optionallyWith(settingDescription.map(value => value: java.lang.String))(
        _.settingDescription
      )
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(applyType.map(value => value: java.lang.String))(
        _.applyType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(isRequired.map(value => value: java.lang.Boolean))(
        _.isRequired
      )
      .optionallyWith(
        minimumEngineVersionPerAllowedValue.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.minimumEngineVersionPerAllowedValue)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly =
    zio.aws.rds.model.OptionGroupOptionSetting.wrap(buildAwsValue())
}
object OptionGroupOptionSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionGroupOptionSetting =
      zio.aws.rds.model.OptionGroupOptionSetting(
        settingName.map(value => value),
        settingDescription.map(value => value),
        defaultValue.map(value => value),
        applyType.map(value => value),
        allowedValues.map(value => value),
        isModifiable.map(value => value),
        isRequired.map(value => value),
        minimumEngineVersionPerAllowedValue.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def settingName: scala.Option[String]
    def settingDescription: scala.Option[String]
    def defaultValue: scala.Option[String]
    def applyType: scala.Option[String]
    def allowedValues: scala.Option[String]
    def isModifiable: scala.Option[Boolean]
    def isRequired: scala.Option[Boolean]
    def minimumEngineVersionPerAllowedValue: scala.Option[List[
      zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.ReadOnly
    ]]
    def getSettingName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("settingName", settingName)
    def getSettingDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("settingDescription", settingDescription)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getApplyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyType", applyType)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getIsRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRequired", isRequired)
    def getMinimumEngineVersionPerAllowedValue: ZIO[Any, AwsError, List[
      zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "minimumEngineVersionPerAllowedValue",
      minimumEngineVersionPerAllowedValue
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting
  ) extends zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly {
    override val settingName: scala.Option[String] =
      scala.Option(impl.settingName()).map(value => value: String)
    override val settingDescription: scala.Option[String] =
      scala.Option(impl.settingDescription()).map(value => value: String)
    override val defaultValue: scala.Option[String] =
      scala.Option(impl.defaultValue()).map(value => value: String)
    override val applyType: scala.Option[String] =
      scala.Option(impl.applyType()).map(value => value: String)
    override val allowedValues: scala.Option[String] =
      scala.Option(impl.allowedValues()).map(value => value: String)
    override val isModifiable: scala.Option[Boolean] =
      scala.Option(impl.isModifiable()).map(value => value: Boolean)
    override val isRequired: scala.Option[Boolean] =
      scala.Option(impl.isRequired()).map(value => value: Boolean)
    override val minimumEngineVersionPerAllowedValue: scala.Option[List[
      zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.ReadOnly
    ]] = scala
      .Option(impl.minimumEngineVersionPerAllowedValue())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting
  ): zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly = new Wrapper(impl)
}
