package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyEventSubscriptionRequest(
    subscriptionName: String,
    snsTopicArn: scala.Option[String] = None,
    sourceType: scala.Option[String] = None,
    eventCategories: scala.Option[Iterable[String]] = None,
    enabled: scala.Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest = {
    import ModifyEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest
      .builder()
      .subscriptionName(subscriptionName: java.lang.String)
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(
        enabled.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyEventSubscriptionRequest.ReadOnly =
    zio.aws.rds.model.ModifyEventSubscriptionRequest.wrap(buildAwsValue())
}
object ModifyEventSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyEventSubscriptionRequest =
      zio.aws.rds.model.ModifyEventSubscriptionRequest(
        subscriptionName,
        snsTopicArn.map(value => value),
        sourceType.map(value => value),
        eventCategories.map(value => value),
        enabled.map(value => value)
      )
    def subscriptionName: String
    def snsTopicArn: scala.Option[String]
    def sourceType: scala.Option[String]
    def eventCategories: scala.Option[List[String]]
    def enabled: scala.Option[BooleanOptional]
    def getSubscriptionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subscriptionName)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest
  ) extends zio.aws.rds.model.ModifyEventSubscriptionRequest.ReadOnly {
    override val subscriptionName: String = impl.subscriptionName(): String
    override val snsTopicArn: scala.Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override val sourceType: scala.Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val eventCategories: scala.Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val enabled: scala.Option[BooleanOptional] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest
  ): zio.aws.rds.model.ModifyEventSubscriptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
