package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{IntegerOptional, BooleanOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyDbProxyRequest(
    dbProxyName: String,
    newDBProxyName: scala.Option[String] = None,
    auth: scala.Option[Iterable[zio.aws.rds.model.UserAuthConfig]] = None,
    requireTLS: scala.Option[BooleanOptional] = None,
    idleClientTimeout: scala.Option[IntegerOptional] = None,
    debugLogging: scala.Option[BooleanOptional] = None,
    roleArn: scala.Option[String] = None,
    securityGroups: scala.Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest = {
    import ModifyDbProxyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest
      .builder()
      .dbProxyName(dbProxyName: java.lang.String)
      .optionallyWith(newDBProxyName.map(value => value: java.lang.String))(
        _.newDBProxyName
      )
      .optionallyWith(
        auth.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.auth)
      .optionallyWith(
        requireTLS.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.requireTLS)
      .optionallyWith(
        idleClientTimeout.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.idleClientTimeout)
      .optionallyWith(
        debugLogging.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.debugLogging)
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbProxyRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbProxyRequest.wrap(buildAwsValue())
}
object ModifyDbProxyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbProxyRequest =
      zio.aws.rds.model.ModifyDbProxyRequest(
        dbProxyName,
        newDBProxyName.map(value => value),
        auth.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requireTLS.map(value => value),
        idleClientTimeout.map(value => value),
        debugLogging.map(value => value),
        roleArn.map(value => value),
        securityGroups.map(value => value)
      )
    def dbProxyName: String
    def newDBProxyName: scala.Option[String]
    def auth: scala.Option[List[zio.aws.rds.model.UserAuthConfig.ReadOnly]]
    def requireTLS: scala.Option[BooleanOptional]
    def idleClientTimeout: scala.Option[IntegerOptional]
    def debugLogging: scala.Option[BooleanOptional]
    def roleArn: scala.Option[String]
    def securityGroups: scala.Option[List[String]]
    def getDbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyName)
    def getNewDBProxyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newDBProxyName", newDBProxyName)
    def getAuth
        : ZIO[Any, AwsError, List[zio.aws.rds.model.UserAuthConfig.ReadOnly]] =
      AwsError.unwrapOptionField("auth", auth)
    def getRequireTLS: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("requireTLS", requireTLS)
    def getIdleClientTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("idleClientTimeout", idleClientTimeout)
    def getDebugLogging: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("debugLogging", debugLogging)
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest
  ) extends zio.aws.rds.model.ModifyDbProxyRequest.ReadOnly {
    override val dbProxyName: String = impl.dbProxyName(): String
    override val newDBProxyName: scala.Option[String] =
      scala.Option(impl.newDBProxyName()).map(value => value: String)
    override val auth
        : scala.Option[List[zio.aws.rds.model.UserAuthConfig.ReadOnly]] = scala
      .Option(impl.auth())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.UserAuthConfig.wrap(item)
        }.toList
      )
    override val requireTLS: scala.Option[BooleanOptional] = scala
      .Option(impl.requireTLS())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val idleClientTimeout: scala.Option[IntegerOptional] = scala
      .Option(impl.idleClientTimeout())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val debugLogging: scala.Option[BooleanOptional] = scala
      .Option(impl.debugLogging())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val roleArn: scala.Option[String] =
      scala.Option(impl.roleArn()).map(value => value: String)
    override val securityGroups: scala.Option[List[String]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest
  ): zio.aws.rds.model.ModifyDbProxyRequest.ReadOnly = new Wrapper(impl)
}
