package zio.aws.rds.model
import zio.aws.rds.model.primitives.{
  Description,
  CustomEngineVersion,
  CustomEngineName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyCustomDbEngineVersionRequest(
    engine: CustomEngineName,
    engineVersion: CustomEngineVersion,
    description: scala.Option[Description] = None,
    status: scala.Option[zio.aws.rds.model.CustomEngineVersionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionRequest = {
    import ModifyCustomDbEngineVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionRequest
      .builder()
      .engine(CustomEngineName.unwrap(engine): java.lang.String)
      .engineVersion(
        CustomEngineVersion.unwrap(engineVersion): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.ModifyCustomDbEngineVersionRequest.ReadOnly =
    zio.aws.rds.model.ModifyCustomDbEngineVersionRequest.wrap(buildAwsValue())
}
object ModifyCustomDbEngineVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyCustomDbEngineVersionRequest =
      zio.aws.rds.model.ModifyCustomDbEngineVersionRequest(
        engine,
        engineVersion,
        description.map(value => value),
        status.map(value => value)
      )
    def engine: CustomEngineName
    def engineVersion: CustomEngineVersion
    def description: scala.Option[Description]
    def status: scala.Option[zio.aws.rds.model.CustomEngineVersionStatus]
    def getEngine: ZIO[Any, Nothing, CustomEngineName] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, Nothing, CustomEngineVersion] =
      ZIO.succeed(engineVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.rds.model.CustomEngineVersionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionRequest
  ) extends zio.aws.rds.model.ModifyCustomDbEngineVersionRequest.ReadOnly {
    override val engine: CustomEngineName =
      zio.aws.rds.model.primitives.CustomEngineName(impl.engine())
    override val engineVersion: CustomEngineVersion =
      zio.aws.rds.model.primitives.CustomEngineVersion(impl.engineVersion())
    override val description: scala.Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.rds.model.primitives.Description(value))
    override val status
        : scala.Option[zio.aws.rds.model.CustomEngineVersionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.rds.model.CustomEngineVersionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionRequest
  ): zio.aws.rds.model.ModifyCustomDbEngineVersionRequest.ReadOnly =
    new Wrapper(impl)
}
