package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyCurrentDbClusterCapacityRequest(
    dbClusterIdentifier: String,
    capacity: scala.Option[IntegerOptional] = None,
    secondsBeforeTimeout: scala.Option[IntegerOptional] = None,
    timeoutAction: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest = {
    import ModifyCurrentDbClusterCapacityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        capacity.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.capacity)
      .optionallyWith(
        secondsBeforeTimeout.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.secondsBeforeTimeout)
      .optionallyWith(timeoutAction.map(value => value: java.lang.String))(
        _.timeoutAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest.ReadOnly =
    zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest
      .wrap(buildAwsValue())
}
object ModifyCurrentDbClusterCapacityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest =
      zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest(
        dbClusterIdentifier,
        capacity.map(value => value),
        secondsBeforeTimeout.map(value => value),
        timeoutAction.map(value => value)
      )
    def dbClusterIdentifier: String
    def capacity: scala.Option[IntegerOptional]
    def secondsBeforeTimeout: scala.Option[IntegerOptional]
    def timeoutAction: scala.Option[String]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getSecondsBeforeTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("secondsBeforeTimeout", secondsBeforeTimeout)
    def getTimeoutAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timeoutAction", timeoutAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest
  ) extends zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val capacity: scala.Option[IntegerOptional] = scala
      .Option(impl.capacity())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val secondsBeforeTimeout: scala.Option[IntegerOptional] = scala
      .Option(impl.secondsBeforeTimeout())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val timeoutAction: scala.Option[String] =
      scala.Option(impl.timeoutAction()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest
  ): zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest.ReadOnly =
    new Wrapper(impl)
}
