package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDbClusterSnapshotRequest(
    dbClusterSnapshotIdentifier: String,
    dbClusterIdentifier: String,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest = {
    import CreateDbClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest
      .builder()
      .dbClusterSnapshotIdentifier(
        dbClusterSnapshotIdentifier: java.lang.String
      )
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbClusterSnapshotRequest.ReadOnly =
    zio.aws.rds.model.CreateDbClusterSnapshotRequest.wrap(buildAwsValue())
}
object CreateDbClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbClusterSnapshotRequest =
      zio.aws.rds.model.CreateDbClusterSnapshotRequest(
        dbClusterSnapshotIdentifier,
        dbClusterIdentifier,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbClusterSnapshotIdentifier: String
    def dbClusterIdentifier: String
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getDbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterSnapshotIdentifier)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest
  ) extends zio.aws.rds.model.CreateDbClusterSnapshotRequest.ReadOnly {
    override val dbClusterSnapshotIdentifier: String =
      impl.dbClusterSnapshotIdentifier(): String
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest
  ): zio.aws.rds.model.CreateDbClusterSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
