package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CharacterSet(
    characterSetName: scala.Option[String] = None,
    characterSetDescription: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CharacterSet = {
    import CharacterSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CharacterSet
      .builder()
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(
        characterSetDescription.map(value => value: java.lang.String)
      )(_.characterSetDescription)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CharacterSet.ReadOnly =
    zio.aws.rds.model.CharacterSet.wrap(buildAwsValue())
}
object CharacterSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.CharacterSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CharacterSet =
      zio.aws.rds.model.CharacterSet(
        characterSetName.map(value => value),
        characterSetDescription.map(value => value)
      )
    def characterSetName: scala.Option[String]
    def characterSetDescription: scala.Option[String]
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getCharacterSetDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("characterSetDescription", characterSetDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CharacterSet
  ) extends zio.aws.rds.model.CharacterSet.ReadOnly {
    override val characterSetName: scala.Option[String] =
      scala.Option(impl.characterSetName()).map(value => value: String)
    override val characterSetDescription: scala.Option[String] =
      scala.Option(impl.characterSetDescription()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CharacterSet
  ): zio.aws.rds.model.CharacterSet.ReadOnly = new Wrapper(impl)
}
