package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpcSecurityGroupMembership(
    vpcSecurityGroupId: scala.Option[String] = None,
    status: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership = {
    import VpcSecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership
      .builder()
      .optionallyWith(vpcSecurityGroupId.map(value => value: java.lang.String))(
        _.vpcSecurityGroupId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly =
    zio.aws.rds.model.VpcSecurityGroupMembership.wrap(buildAwsValue())
}
object VpcSecurityGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.VpcSecurityGroupMembership =
      zio.aws.rds.model.VpcSecurityGroupMembership(
        vpcSecurityGroupId.map(value => value),
        status.map(value => value)
      )
    def vpcSecurityGroupId: scala.Option[String]
    def status: scala.Option[String]
    def getVpcSecurityGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcSecurityGroupId", vpcSecurityGroupId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership
  ) extends zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly {
    override val vpcSecurityGroupId: scala.Option[String] =
      scala.Option(impl.vpcSecurityGroupId()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership
  ): zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly = new Wrapper(impl)
}
