package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Tag(
    key: scala.Option[String] = None,
    value: scala.Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Tag
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Tag.ReadOnly =
    zio.aws.rds.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Tag =
      zio.aws.rds.model.Tag(key.map(value => value), value.map(value => value))
    def key: scala.Option[String]
    def value: scala.Option[String]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Tag
  ) extends zio.aws.rds.model.Tag.ReadOnly {
    override val key: scala.Option[String] =
      scala.Option(impl.key()).map(value => value: String)
    override val value: scala.Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Tag
  ): zio.aws.rds.model.Tag.ReadOnly = new Wrapper(impl)
}
