package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScalingConfigurationInfo(
    minCapacity: scala.Option[IntegerOptional] = None,
    maxCapacity: scala.Option[IntegerOptional] = None,
    autoPause: scala.Option[BooleanOptional] = None,
    secondsUntilAutoPause: scala.Option[IntegerOptional] = None,
    timeoutAction: scala.Option[String] = None,
    secondsBeforeTimeout: scala.Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ScalingConfigurationInfo = {
    import ScalingConfigurationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ScalingConfigurationInfo
      .builder()
      .optionallyWith(
        minCapacity.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.minCapacity)
      .optionallyWith(
        maxCapacity.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxCapacity)
      .optionallyWith(
        autoPause.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.autoPause)
      .optionallyWith(
        secondsUntilAutoPause.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.secondsUntilAutoPause)
      .optionallyWith(timeoutAction.map(value => value: java.lang.String))(
        _.timeoutAction
      )
      .optionallyWith(
        secondsBeforeTimeout.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.secondsBeforeTimeout)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ScalingConfigurationInfo.ReadOnly =
    zio.aws.rds.model.ScalingConfigurationInfo.wrap(buildAwsValue())
}
object ScalingConfigurationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ScalingConfigurationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ScalingConfigurationInfo =
      zio.aws.rds.model.ScalingConfigurationInfo(
        minCapacity.map(value => value),
        maxCapacity.map(value => value),
        autoPause.map(value => value),
        secondsUntilAutoPause.map(value => value),
        timeoutAction.map(value => value),
        secondsBeforeTimeout.map(value => value)
      )
    def minCapacity: scala.Option[IntegerOptional]
    def maxCapacity: scala.Option[IntegerOptional]
    def autoPause: scala.Option[BooleanOptional]
    def secondsUntilAutoPause: scala.Option[IntegerOptional]
    def timeoutAction: scala.Option[String]
    def secondsBeforeTimeout: scala.Option[IntegerOptional]
    def getMinCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("minCapacity", minCapacity)
    def getMaxCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
    def getAutoPause: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("autoPause", autoPause)
    def getSecondsUntilAutoPause: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("secondsUntilAutoPause", secondsUntilAutoPause)
    def getTimeoutAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timeoutAction", timeoutAction)
    def getSecondsBeforeTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("secondsBeforeTimeout", secondsBeforeTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ScalingConfigurationInfo
  ) extends zio.aws.rds.model.ScalingConfigurationInfo.ReadOnly {
    override val minCapacity: scala.Option[IntegerOptional] = scala
      .Option(impl.minCapacity())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val maxCapacity: scala.Option[IntegerOptional] = scala
      .Option(impl.maxCapacity())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val autoPause: scala.Option[BooleanOptional] = scala
      .Option(impl.autoPause())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val secondsUntilAutoPause: scala.Option[IntegerOptional] = scala
      .Option(impl.secondsUntilAutoPause())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val timeoutAction: scala.Option[String] =
      scala.Option(impl.timeoutAction()).map(value => value: String)
    override val secondsBeforeTimeout: scala.Option[IntegerOptional] = scala
      .Option(impl.secondsBeforeTimeout())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ScalingConfigurationInfo
  ): zio.aws.rds.model.ScalingConfigurationInfo.ReadOnly = new Wrapper(impl)
}
