package zio.aws.rds.model
import zio.aws.rds.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RestoreWindow(
    earliestTime: scala.Option[TStamp] = None,
    latestTime: scala.Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreWindow = {
    import RestoreWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreWindow
      .builder()
      .optionallyWith(earliestTime.map(value => TStamp.unwrap(value): Instant))(
        _.earliestTime
      )
      .optionallyWith(latestTime.map(value => TStamp.unwrap(value): Instant))(
        _.latestTime
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RestoreWindow.ReadOnly =
    zio.aws.rds.model.RestoreWindow.wrap(buildAwsValue())
}
object RestoreWindow {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.RestoreWindow] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreWindow =
      zio.aws.rds.model.RestoreWindow(
        earliestTime.map(value => value),
        latestTime.map(value => value)
      )
    def earliestTime: scala.Option[TStamp]
    def latestTime: scala.Option[TStamp]
    def getEarliestTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("earliestTime", earliestTime)
    def getLatestTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("latestTime", latestTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreWindow
  ) extends zio.aws.rds.model.RestoreWindow.ReadOnly {
    override val earliestTime: scala.Option[TStamp] = scala
      .Option(impl.earliestTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val latestTime: scala.Option[TStamp] = scala
      .Option(impl.latestTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreWindow
  ): zio.aws.rds.model.RestoreWindow.ReadOnly = new Wrapper(impl)
}
