package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreDbInstanceFromS3Request(
    dbName: scala.Option[String] = None,
    dbInstanceIdentifier: String,
    allocatedStorage: scala.Option[IntegerOptional] = None,
    dbInstanceClass: String,
    engine: String,
    masterUsername: scala.Option[String] = None,
    masterUserPassword: scala.Option[String] = None,
    dbSecurityGroups: scala.Option[Iterable[String]] = None,
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    availabilityZone: scala.Option[String] = None,
    dbSubnetGroupName: scala.Option[String] = None,
    preferredMaintenanceWindow: scala.Option[String] = None,
    dbParameterGroupName: scala.Option[String] = None,
    backupRetentionPeriod: scala.Option[IntegerOptional] = None,
    preferredBackupWindow: scala.Option[String] = None,
    port: scala.Option[IntegerOptional] = None,
    multiAZ: scala.Option[BooleanOptional] = None,
    engineVersion: scala.Option[String] = None,
    autoMinorVersionUpgrade: scala.Option[BooleanOptional] = None,
    licenseModel: scala.Option[String] = None,
    iops: scala.Option[IntegerOptional] = None,
    optionGroupName: scala.Option[String] = None,
    publiclyAccessible: scala.Option[BooleanOptional] = None,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None,
    storageType: scala.Option[String] = None,
    storageEncrypted: scala.Option[BooleanOptional] = None,
    kmsKeyId: scala.Option[String] = None,
    copyTagsToSnapshot: scala.Option[BooleanOptional] = None,
    monitoringInterval: scala.Option[IntegerOptional] = None,
    monitoringRoleArn: scala.Option[String] = None,
    enableIAMDatabaseAuthentication: scala.Option[BooleanOptional] = None,
    sourceEngine: String,
    sourceEngineVersion: String,
    s3BucketName: String,
    s3Prefix: scala.Option[String] = None,
    s3IngestionRoleArn: String,
    enablePerformanceInsights: scala.Option[BooleanOptional] = None,
    performanceInsightsKMSKeyId: scala.Option[String] = None,
    performanceInsightsRetentionPeriod: scala.Option[IntegerOptional] = None,
    enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None,
    processorFeatures: scala.Option[Iterable[
      zio.aws.rds.model.ProcessorFeature
    ]] = None,
    useDefaultProcessorFeatures: scala.Option[BooleanOptional] = None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    maxAllocatedStorage: scala.Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Request = {
    import RestoreDbInstanceFromS3Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Request
      .builder()
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(
        allocatedStorage.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.allocatedStorage)
      .dbInstanceClass(dbInstanceClass: java.lang.String)
      .engine(engine: java.lang.String)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        dbSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dbSecurityGroups)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .optionallyWith(
        backupRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.backupRetentionPeriod)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(
        multiAZ.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(
        iops.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        publiclyAccessible.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.publiclyAccessible)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        storageEncrypted.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.storageEncrypted)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        copyTagsToSnapshot.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        monitoringInterval.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.monitoringInterval)
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enableIAMDatabaseAuthentication)
      .sourceEngine(sourceEngine: java.lang.String)
      .sourceEngineVersion(sourceEngineVersion: java.lang.String)
      .s3BucketName(s3BucketName: java.lang.String)
      .optionallyWith(s3Prefix.map(value => value: java.lang.String))(
        _.s3Prefix
      )
      .s3IngestionRoleArn(s3IngestionRoleArn: java.lang.String)
      .optionallyWith(
        enablePerformanceInsights.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        useDefaultProcessorFeatures.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.useDefaultProcessorFeatures)
      .optionallyWith(
        deletionProtection.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(
        maxAllocatedStorage.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxAllocatedStorage)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RestoreDbInstanceFromS3Request.ReadOnly =
    zio.aws.rds.model.RestoreDbInstanceFromS3Request.wrap(buildAwsValue())
}
object RestoreDbInstanceFromS3Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbInstanceFromS3Request =
      zio.aws.rds.model.RestoreDbInstanceFromS3Request(
        dbName.map(value => value),
        dbInstanceIdentifier,
        allocatedStorage.map(value => value),
        dbInstanceClass,
        engine,
        masterUsername.map(value => value),
        masterUserPassword.map(value => value),
        dbSecurityGroups.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        availabilityZone.map(value => value),
        dbSubnetGroupName.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        dbParameterGroupName.map(value => value),
        backupRetentionPeriod.map(value => value),
        preferredBackupWindow.map(value => value),
        port.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        publiclyAccessible.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageType.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        copyTagsToSnapshot.map(value => value),
        monitoringInterval.map(value => value),
        monitoringRoleArn.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        sourceEngine,
        sourceEngineVersion,
        s3BucketName,
        s3Prefix.map(value => value),
        s3IngestionRoleArn,
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        useDefaultProcessorFeatures.map(value => value),
        deletionProtection.map(value => value),
        maxAllocatedStorage.map(value => value)
      )
    def dbName: scala.Option[String]
    def dbInstanceIdentifier: String
    def allocatedStorage: scala.Option[IntegerOptional]
    def dbInstanceClass: String
    def engine: String
    def masterUsername: scala.Option[String]
    def masterUserPassword: scala.Option[String]
    def dbSecurityGroups: scala.Option[List[String]]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def availabilityZone: scala.Option[String]
    def dbSubnetGroupName: scala.Option[String]
    def preferredMaintenanceWindow: scala.Option[String]
    def dbParameterGroupName: scala.Option[String]
    def backupRetentionPeriod: scala.Option[IntegerOptional]
    def preferredBackupWindow: scala.Option[String]
    def port: scala.Option[IntegerOptional]
    def multiAZ: scala.Option[BooleanOptional]
    def engineVersion: scala.Option[String]
    def autoMinorVersionUpgrade: scala.Option[BooleanOptional]
    def licenseModel: scala.Option[String]
    def iops: scala.Option[IntegerOptional]
    def optionGroupName: scala.Option[String]
    def publiclyAccessible: scala.Option[BooleanOptional]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def storageType: scala.Option[String]
    def storageEncrypted: scala.Option[BooleanOptional]
    def kmsKeyId: scala.Option[String]
    def copyTagsToSnapshot: scala.Option[BooleanOptional]
    def monitoringInterval: scala.Option[IntegerOptional]
    def monitoringRoleArn: scala.Option[String]
    def enableIAMDatabaseAuthentication: scala.Option[BooleanOptional]
    def sourceEngine: String
    def sourceEngineVersion: String
    def s3BucketName: String
    def s3Prefix: scala.Option[String]
    def s3IngestionRoleArn: String
    def enablePerformanceInsights: scala.Option[BooleanOptional]
    def performanceInsightsKMSKeyId: scala.Option[String]
    def performanceInsightsRetentionPeriod: scala.Option[IntegerOptional]
    def enableCloudwatchLogsExports: scala.Option[List[String]]
    def processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def useDefaultProcessorFeatures: scala.Option[BooleanOptional]
    def deletionProtection: scala.Option[BooleanOptional]
    def maxAllocatedStorage: scala.Option[IntegerOptional]
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getDbInstanceClass: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceClass)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getDbSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroups)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getSourceEngine: ZIO[Any, Nothing, String] = ZIO.succeed(sourceEngine)
    def getSourceEngineVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceEngineVersion)
    def getS3BucketName: ZIO[Any, Nothing, String] = ZIO.succeed(s3BucketName)
    def getS3Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
    def getS3IngestionRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(s3IngestionRoleArn)
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getUseDefaultProcessorFeatures: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "useDefaultProcessorFeatures",
        useDefaultProcessorFeatures
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Request
  ) extends zio.aws.rds.model.RestoreDbInstanceFromS3Request.ReadOnly {
    override val dbName: scala.Option[String] =
      scala.Option(impl.dbName()).map(value => value: String)
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val allocatedStorage: scala.Option[IntegerOptional] = scala
      .Option(impl.allocatedStorage())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val dbInstanceClass: String = impl.dbInstanceClass(): String
    override val engine: String = impl.engine(): String
    override val masterUsername: scala.Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val masterUserPassword: scala.Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override val dbSecurityGroups: scala.Option[List[String]] = scala
      .Option(impl.dbSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val availabilityZone: scala.Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val dbSubnetGroupName: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val preferredMaintenanceWindow: scala.Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val dbParameterGroupName: scala.Option[String] =
      scala.Option(impl.dbParameterGroupName()).map(value => value: String)
    override val backupRetentionPeriod: scala.Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val preferredBackupWindow: scala.Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val port: scala.Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val multiAZ: scala.Option[BooleanOptional] = scala
      .Option(impl.multiAZ())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val autoMinorVersionUpgrade: scala.Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val licenseModel: scala.Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val iops: scala.Option[IntegerOptional] = scala
      .Option(impl.iops())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val publiclyAccessible: scala.Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val storageEncrypted: scala.Option[BooleanOptional] = scala
      .Option(impl.storageEncrypted())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val copyTagsToSnapshot: scala.Option[BooleanOptional] = scala
      .Option(impl.copyTagsToSnapshot())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val monitoringInterval: scala.Option[IntegerOptional] = scala
      .Option(impl.monitoringInterval())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val monitoringRoleArn: scala.Option[String] =
      scala.Option(impl.monitoringRoleArn()).map(value => value: String)
    override val enableIAMDatabaseAuthentication
        : scala.Option[BooleanOptional] = scala
      .Option(impl.enableIAMDatabaseAuthentication())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val sourceEngine: String = impl.sourceEngine(): String
    override val sourceEngineVersion: String =
      impl.sourceEngineVersion(): String
    override val s3BucketName: String = impl.s3BucketName(): String
    override val s3Prefix: scala.Option[String] =
      scala.Option(impl.s3Prefix()).map(value => value: String)
    override val s3IngestionRoleArn: String = impl.s3IngestionRoleArn(): String
    override val enablePerformanceInsights: scala.Option[BooleanOptional] =
      scala
        .Option(impl.enablePerformanceInsights())
        .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val performanceInsightsKMSKeyId: scala.Option[String] = scala
      .Option(impl.performanceInsightsKMSKeyId())
      .map(value => value: String)
    override val performanceInsightsRetentionPeriod
        : scala.Option[IntegerOptional] = scala
      .Option(impl.performanceInsightsRetentionPeriod())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val enableCloudwatchLogsExports: scala.Option[List[String]] = scala
      .Option(impl.enableCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      scala
        .Option(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val useDefaultProcessorFeatures: scala.Option[BooleanOptional] =
      scala
        .Option(impl.useDefaultProcessorFeatures())
        .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val maxAllocatedStorage: scala.Option[IntegerOptional] = scala
      .Option(impl.maxAllocatedStorage())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Request
  ): zio.aws.rds.model.RestoreDbInstanceFromS3Request.ReadOnly = new Wrapper(
    impl
  )
}
