package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Option(
    optionName: scala.Option[String] = None,
    optionDescription: scala.Option[String] = None,
    persistent: scala.Option[Boolean] = None,
    permanent: scala.Option[Boolean] = None,
    port: scala.Option[IntegerOptional] = None,
    optionVersion: scala.Option[String] = None,
    optionSettings: scala.Option[Iterable[zio.aws.rds.model.OptionSetting]] =
      None,
    dbSecurityGroupMemberships: scala.Option[Iterable[
      zio.aws.rds.model.DBSecurityGroupMembership
    ]] = None,
    vpcSecurityGroupMemberships: scala.Option[Iterable[
      zio.aws.rds.model.VpcSecurityGroupMembership
    ]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Option = {
    import Option.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Option
      .builder()
      .optionallyWith(optionName.map(value => value: java.lang.String))(
        _.optionName
      )
      .optionallyWith(optionDescription.map(value => value: java.lang.String))(
        _.optionDescription
      )
      .optionallyWith(persistent.map(value => value: java.lang.Boolean))(
        _.persistent
      )
      .optionallyWith(permanent.map(value => value: java.lang.Boolean))(
        _.permanent
      )
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(optionVersion.map(value => value: java.lang.String))(
        _.optionVersion
      )
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .optionallyWith(
        dbSecurityGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbSecurityGroupMemberships)
      .optionallyWith(
        vpcSecurityGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupMemberships)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Option.ReadOnly =
    zio.aws.rds.model.Option.wrap(buildAwsValue())
}
object Option {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Option] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Option = zio.aws.rds.model.Option(
      optionName.map(value => value),
      optionDescription.map(value => value),
      persistent.map(value => value),
      permanent.map(value => value),
      port.map(value => value),
      optionVersion.map(value => value),
      optionSettings.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      dbSecurityGroupMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpcSecurityGroupMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def optionName: scala.Option[String]
    def optionDescription: scala.Option[String]
    def persistent: scala.Option[Boolean]
    def permanent: scala.Option[Boolean]
    def port: scala.Option[IntegerOptional]
    def optionVersion: scala.Option[String]
    def optionSettings
        : scala.Option[List[zio.aws.rds.model.OptionSetting.ReadOnly]]
    def dbSecurityGroupMemberships: scala.Option[List[
      zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly
    ]]
    def vpcSecurityGroupMemberships: scala.Option[List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]]
    def getOptionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionName", optionName)
    def getOptionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionDescription", optionDescription)
    def getPersistent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("persistent", persistent)
    def getPermanent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("permanent", permanent)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getOptionVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionVersion", optionVersion)
    def getOptionSettings
        : ZIO[Any, AwsError, List[zio.aws.rds.model.OptionSetting.ReadOnly]] =
      AwsError.unwrapOptionField("optionSettings", optionSettings)
    def getDbSecurityGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbSecurityGroupMemberships",
      dbSecurityGroupMemberships
    )
    def getVpcSecurityGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "vpcSecurityGroupMemberships",
      vpcSecurityGroupMemberships
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Option
  ) extends zio.aws.rds.model.Option.ReadOnly {
    override val optionName: scala.Option[String] =
      scala.Option(impl.optionName()).map(value => value: String)
    override val optionDescription: scala.Option[String] =
      scala.Option(impl.optionDescription()).map(value => value: String)
    override val persistent: scala.Option[Boolean] =
      scala.Option(impl.persistent()).map(value => value: Boolean)
    override val permanent: scala.Option[Boolean] =
      scala.Option(impl.permanent()).map(value => value: Boolean)
    override val port: scala.Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val optionVersion: scala.Option[String] =
      scala.Option(impl.optionVersion()).map(value => value: String)
    override val optionSettings
        : scala.Option[List[zio.aws.rds.model.OptionSetting.ReadOnly]] = scala
      .Option(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.OptionSetting.wrap(item)
        }.toList
      )
    override val dbSecurityGroupMemberships: scala.Option[List[
      zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly
    ]] = scala
      .Option(impl.dbSecurityGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val vpcSecurityGroupMemberships: scala.Option[List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]] = scala
      .Option(impl.vpcSecurityGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Option
  ): zio.aws.rds.model.Option.ReadOnly = new Wrapper(impl)
}
