package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EngineDefaults(
    dbParameterGroupFamily: scala.Option[String] = None,
    marker: scala.Option[String] = None,
    parameters: scala.Option[Iterable[zio.aws.rds.model.Parameter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.EngineDefaults = {
    import EngineDefaults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.EngineDefaults
      .builder()
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.EngineDefaults.ReadOnly =
    zio.aws.rds.model.EngineDefaults.wrap(buildAwsValue())
}
object EngineDefaults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.EngineDefaults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.EngineDefaults =
      zio.aws.rds.model.EngineDefaults(
        dbParameterGroupFamily.map(value => value),
        marker.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbParameterGroupFamily: scala.Option[String]
    def marker: scala.Option[String]
    def parameters: scala.Option[List[zio.aws.rds.model.Parameter.ReadOnly]]
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.EngineDefaults
  ) extends zio.aws.rds.model.EngineDefaults.ReadOnly {
    override val dbParameterGroupFamily: scala.Option[String] =
      scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val parameters
        : scala.Option[List[zio.aws.rds.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Parameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.EngineDefaults
  ): zio.aws.rds.model.EngineDefaults.ReadOnly = new Wrapper(impl)
}
