package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbProxyEndpointsResponse(
    dbProxyEndpoints: scala.Option[Iterable[
      zio.aws.rds.model.DBProxyEndpoint
    ]] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse = {
    import DescribeDbProxyEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse
      .builder()
      .optionallyWith(
        dbProxyEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbProxyEndpoints)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbProxyEndpointsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbProxyEndpointsResponse.wrap(buildAwsValue())
}
object DescribeDbProxyEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbProxyEndpointsResponse =
      zio.aws.rds.model.DescribeDbProxyEndpointsResponse(
        dbProxyEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def dbProxyEndpoints
        : scala.Option[List[zio.aws.rds.model.DBProxyEndpoint.ReadOnly]]
    def marker: scala.Option[String]
    def getDbProxyEndpoints
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBProxyEndpoint.ReadOnly]] =
      AwsError.unwrapOptionField("dbProxyEndpoints", dbProxyEndpoints)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse
  ) extends zio.aws.rds.model.DescribeDbProxyEndpointsResponse.ReadOnly {
    override val dbProxyEndpoints
        : scala.Option[List[zio.aws.rds.model.DBProxyEndpoint.ReadOnly]] = scala
      .Option(impl.dbProxyEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBProxyEndpoint.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse
  ): zio.aws.rds.model.DescribeDbProxyEndpointsResponse.ReadOnly = new Wrapper(
    impl
  )
}
