package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterSnapshotsRequest(
    dbClusterIdentifier: scala.Option[String] = None,
    dbClusterSnapshotIdentifier: scala.Option[String] = None,
    snapshotType: scala.Option[String] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None,
    maxRecords: scala.Option[IntegerOptional] = None,
    marker: scala.Option[String] = None,
    includeShared: scala.Option[Boolean] = None,
    includePublic: scala.Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest = {
    import DescribeDbClusterSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest
      .builder()
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterSnapshotIdentifier)
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(includeShared.map(value => value: java.lang.Boolean))(
        _.includeShared
      )
      .optionallyWith(includePublic.map(value => value: java.lang.Boolean))(
        _.includePublic
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbClusterSnapshotsRequest.ReadOnly =
    zio.aws.rds.model.DescribeDbClusterSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeDbClusterSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbClusterSnapshotsRequest =
      zio.aws.rds.model.DescribeDbClusterSnapshotsRequest(
        dbClusterIdentifier.map(value => value),
        dbClusterSnapshotIdentifier.map(value => value),
        snapshotType.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value),
        includeShared.map(value => value),
        includePublic.map(value => value)
      )
    def dbClusterIdentifier: scala.Option[String]
    def dbClusterSnapshotIdentifier: scala.Option[String]
    def snapshotType: scala.Option[String]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: scala.Option[IntegerOptional]
    def marker: scala.Option[String]
    def includeShared: scala.Option[Boolean]
    def includePublic: scala.Option[Boolean]
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterSnapshotIdentifier",
        dbClusterSnapshotIdentifier
      )
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getIncludeShared: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeShared", includeShared)
    def getIncludePublic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includePublic", includePublic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest
  ) extends zio.aws.rds.model.DescribeDbClusterSnapshotsRequest.ReadOnly {
    override val dbClusterIdentifier: scala.Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val dbClusterSnapshotIdentifier: scala.Option[String] = scala
      .Option(impl.dbClusterSnapshotIdentifier())
      .map(value => value: String)
    override val snapshotType: scala.Option[String] =
      scala.Option(impl.snapshotType()).map(value => value: String)
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: scala.Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val includeShared: scala.Option[Boolean] =
      scala.Option(impl.includeShared()).map(value => value: Boolean)
    override val includePublic: scala.Option[Boolean] =
      scala.Option(impl.includePublic()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest
  ): zio.aws.rds.model.DescribeDbClusterSnapshotsRequest.ReadOnly = new Wrapper(
    impl
  )
}
