package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopyOptionGroupRequest(
    sourceOptionGroupIdentifier: String,
    targetOptionGroupIdentifier: String,
    targetOptionGroupDescription: String,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest = {
    import CopyOptionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest
      .builder()
      .sourceOptionGroupIdentifier(
        sourceOptionGroupIdentifier: java.lang.String
      )
      .targetOptionGroupIdentifier(
        targetOptionGroupIdentifier: java.lang.String
      )
      .targetOptionGroupDescription(
        targetOptionGroupDescription: java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CopyOptionGroupRequest.ReadOnly =
    zio.aws.rds.model.CopyOptionGroupRequest.wrap(buildAwsValue())
}
object CopyOptionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CopyOptionGroupRequest =
      zio.aws.rds.model.CopyOptionGroupRequest(
        sourceOptionGroupIdentifier,
        targetOptionGroupIdentifier,
        targetOptionGroupDescription,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceOptionGroupIdentifier: String
    def targetOptionGroupIdentifier: String
    def targetOptionGroupDescription: String
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getSourceOptionGroupIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceOptionGroupIdentifier)
    def getTargetOptionGroupIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetOptionGroupIdentifier)
    def getTargetOptionGroupDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetOptionGroupDescription)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest
  ) extends zio.aws.rds.model.CopyOptionGroupRequest.ReadOnly {
    override val sourceOptionGroupIdentifier: String =
      impl.sourceOptionGroupIdentifier(): String
    override val targetOptionGroupIdentifier: String =
      impl.targetOptionGroupIdentifier(): String
    override val targetOptionGroupDescription: String =
      impl.targetOptionGroupDescription(): String
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest
  ): zio.aws.rds.model.CopyOptionGroupRequest.ReadOnly = new Wrapper(impl)
}
