package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopyDbSnapshotRequest(
    sourceDBSnapshotIdentifier: String,
    targetDBSnapshotIdentifier: String,
    kmsKeyId: scala.Option[String] = None,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None,
    copyTags: scala.Option[BooleanOptional] = None,
    preSignedUrl: scala.Option[String] = None,
    optionGroupName: scala.Option[String] = None,
    targetCustomAvailabilityZone: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest = {
    import CopyDbSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest
      .builder()
      .sourceDBSnapshotIdentifier(sourceDBSnapshotIdentifier: java.lang.String)
      .targetDBSnapshotIdentifier(targetDBSnapshotIdentifier: java.lang.String)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        copyTags.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.copyTags)
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        targetCustomAvailabilityZone.map(value => value: java.lang.String)
      )(_.targetCustomAvailabilityZone)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CopyDbSnapshotRequest.ReadOnly =
    zio.aws.rds.model.CopyDbSnapshotRequest.wrap(buildAwsValue())
}
object CopyDbSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CopyDbSnapshotRequest =
      zio.aws.rds.model.CopyDbSnapshotRequest(
        sourceDBSnapshotIdentifier,
        targetDBSnapshotIdentifier,
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        copyTags.map(value => value),
        preSignedUrl.map(value => value),
        optionGroupName.map(value => value),
        targetCustomAvailabilityZone.map(value => value)
      )
    def sourceDBSnapshotIdentifier: String
    def targetDBSnapshotIdentifier: String
    def kmsKeyId: scala.Option[String]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def copyTags: scala.Option[BooleanOptional]
    def preSignedUrl: scala.Option[String]
    def optionGroupName: scala.Option[String]
    def targetCustomAvailabilityZone: scala.Option[String]
    def getSourceDBSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBSnapshotIdentifier)
    def getTargetDBSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBSnapshotIdentifier)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCopyTags: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getTargetCustomAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetCustomAvailabilityZone",
        targetCustomAvailabilityZone
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest
  ) extends zio.aws.rds.model.CopyDbSnapshotRequest.ReadOnly {
    override val sourceDBSnapshotIdentifier: String =
      impl.sourceDBSnapshotIdentifier(): String
    override val targetDBSnapshotIdentifier: String =
      impl.targetDBSnapshotIdentifier(): String
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val copyTags: scala.Option[BooleanOptional] = scala
      .Option(impl.copyTags())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val preSignedUrl: scala.Option[String] =
      scala.Option(impl.preSignedUrl()).map(value => value: String)
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val targetCustomAvailabilityZone: scala.Option[String] = scala
      .Option(impl.targetCustomAvailabilityZone())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest
  ): zio.aws.rds.model.CopyDbSnapshotRequest.ReadOnly = new Wrapper(impl)
}
