package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopyDbClusterParameterGroupResponse(
    dbClusterParameterGroup: scala.Option[
      zio.aws.rds.model.DBClusterParameterGroup
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse = {
    import CopyDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse
      .builder()
      .optionallyWith(
        dbClusterParameterGroup.map(value => value.buildAwsValue())
      )(_.dbClusterParameterGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.CopyDbClusterParameterGroupResponse.ReadOnly =
    zio.aws.rds.model.CopyDbClusterParameterGroupResponse.wrap(buildAwsValue())
}
object CopyDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CopyDbClusterParameterGroupResponse =
      zio.aws.rds.model.CopyDbClusterParameterGroupResponse(
        dbClusterParameterGroup.map(value => value.asEditable)
      )
    def dbClusterParameterGroup
        : scala.Option[zio.aws.rds.model.DBClusterParameterGroup.ReadOnly]
    def getDbClusterParameterGroup: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.DBClusterParameterGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbClusterParameterGroup",
      dbClusterParameterGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse
  ) extends zio.aws.rds.model.CopyDbClusterParameterGroupResponse.ReadOnly {
    override val dbClusterParameterGroup
        : scala.Option[zio.aws.rds.model.DBClusterParameterGroup.ReadOnly] =
      scala
        .Option(impl.dbClusterParameterGroup())
        .map(value => zio.aws.rds.model.DBClusterParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse
  ): zio.aws.rds.model.CopyDbClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
