package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConnectionPoolConfiguration(
    maxConnectionsPercent: scala.Option[IntegerOptional] = None,
    maxIdleConnectionsPercent: scala.Option[IntegerOptional] = None,
    connectionBorrowTimeout: scala.Option[IntegerOptional] = None,
    sessionPinningFilters: scala.Option[Iterable[String]] = None,
    initQuery: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration = {
    import ConnectionPoolConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration
      .builder()
      .optionallyWith(
        maxConnectionsPercent.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.maxConnectionsPercent)
      .optionallyWith(
        maxIdleConnectionsPercent.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.maxIdleConnectionsPercent)
      .optionallyWith(
        connectionBorrowTimeout.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.connectionBorrowTimeout)
      .optionallyWith(
        sessionPinningFilters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sessionPinningFilters)
      .optionallyWith(initQuery.map(value => value: java.lang.String))(
        _.initQuery
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ConnectionPoolConfiguration.ReadOnly =
    zio.aws.rds.model.ConnectionPoolConfiguration.wrap(buildAwsValue())
}
object ConnectionPoolConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ConnectionPoolConfiguration =
      zio.aws.rds.model.ConnectionPoolConfiguration(
        maxConnectionsPercent.map(value => value),
        maxIdleConnectionsPercent.map(value => value),
        connectionBorrowTimeout.map(value => value),
        sessionPinningFilters.map(value => value),
        initQuery.map(value => value)
      )
    def maxConnectionsPercent: scala.Option[IntegerOptional]
    def maxIdleConnectionsPercent: scala.Option[IntegerOptional]
    def connectionBorrowTimeout: scala.Option[IntegerOptional]
    def sessionPinningFilters: scala.Option[List[String]]
    def initQuery: scala.Option[String]
    def getMaxConnectionsPercent: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxConnectionsPercent", maxConnectionsPercent)
    def getMaxIdleConnectionsPercent: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "maxIdleConnectionsPercent",
        maxIdleConnectionsPercent
      )
    def getConnectionBorrowTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "connectionBorrowTimeout",
        connectionBorrowTimeout
      )
    def getSessionPinningFilters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sessionPinningFilters", sessionPinningFilters)
    def getInitQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("initQuery", initQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration
  ) extends zio.aws.rds.model.ConnectionPoolConfiguration.ReadOnly {
    override val maxConnectionsPercent: scala.Option[IntegerOptional] = scala
      .Option(impl.maxConnectionsPercent())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val maxIdleConnectionsPercent: scala.Option[IntegerOptional] =
      scala
        .Option(impl.maxIdleConnectionsPercent())
        .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val connectionBorrowTimeout: scala.Option[IntegerOptional] = scala
      .Option(impl.connectionBorrowTimeout())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val sessionPinningFilters: scala.Option[List[String]] = scala
      .Option(impl.sessionPinningFilters())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val initQuery: scala.Option[String] =
      scala.Option(impl.initQuery()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration
  ): zio.aws.rds.model.ConnectionPoolConfiguration.ReadOnly = new Wrapper(impl)
}
