package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizeDbSecurityGroupIngressRequest(
    dbSecurityGroupName: String,
    cidrip: scala.Option[String] = None,
    ec2SecurityGroupName: scala.Option[String] = None,
    ec2SecurityGroupId: scala.Option[String] = None,
    ec2SecurityGroupOwnerId: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest = {
    import AuthorizeDbSecurityGroupIngressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest
      .builder()
      .dbSecurityGroupName(dbSecurityGroupName: java.lang.String)
      .optionallyWith(cidrip.map(value => value: java.lang.String))(_.cidrip)
      .optionallyWith(
        ec2SecurityGroupName.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupName)
      .optionallyWith(ec2SecurityGroupId.map(value => value: java.lang.String))(
        _.ec2SecurityGroupId
      )
      .optionallyWith(
        ec2SecurityGroupOwnerId.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupOwnerId)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.AuthorizeDbSecurityGroupIngressRequest.ReadOnly =
    zio.aws.rds.model.AuthorizeDbSecurityGroupIngressRequest
      .wrap(buildAwsValue())
}
object AuthorizeDbSecurityGroupIngressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.AuthorizeDbSecurityGroupIngressRequest =
      zio.aws.rds.model.AuthorizeDbSecurityGroupIngressRequest(
        dbSecurityGroupName,
        cidrip.map(value => value),
        ec2SecurityGroupName.map(value => value),
        ec2SecurityGroupId.map(value => value),
        ec2SecurityGroupOwnerId.map(value => value)
      )
    def dbSecurityGroupName: String
    def cidrip: scala.Option[String]
    def ec2SecurityGroupName: scala.Option[String]
    def ec2SecurityGroupId: scala.Option[String]
    def ec2SecurityGroupOwnerId: scala.Option[String]
    def getDbSecurityGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSecurityGroupName)
    def getCidrip: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrip", cidrip)
    def getEc2SecurityGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2SecurityGroupName", ec2SecurityGroupName)
    def getEc2SecurityGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2SecurityGroupId", ec2SecurityGroupId)
    def getEc2SecurityGroupOwnerId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("ec2SecurityGroupOwnerId", ec2SecurityGroupOwnerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest
  ) extends zio.aws.rds.model.AuthorizeDbSecurityGroupIngressRequest.ReadOnly {
    override val dbSecurityGroupName: String =
      impl.dbSecurityGroupName(): String
    override val cidrip: scala.Option[String] =
      scala.Option(impl.cidrip()).map(value => value: String)
    override val ec2SecurityGroupName: scala.Option[String] =
      scala.Option(impl.ec2SecurityGroupName()).map(value => value: String)
    override val ec2SecurityGroupId: scala.Option[String] =
      scala.Option(impl.ec2SecurityGroupId()).map(value => value: String)
    override val ec2SecurityGroupOwnerId: scala.Option[String] =
      scala.Option(impl.ec2SecurityGroupOwnerId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest
  ): zio.aws.rds.model.AuthorizeDbSecurityGroupIngressRequest.ReadOnly =
    new Wrapper(impl)
}
