package zio.aws.qldb.model
import scala.jdk.CollectionConverters.*
sealed trait ErrorCause {
  def unwrap: software.amazon.awssdk.services.qldb.model.ErrorCause
}
object ErrorCause {
  def wrap(
      value: software.amazon.awssdk.services.qldb.model.ErrorCause
  ): zio.aws.qldb.model.ErrorCause = value match {
    case software.amazon.awssdk.services.qldb.model.ErrorCause.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.qldb.model.ErrorCause.KINESIS_STREAM_NOT_FOUND =>
      val r = KINESIS_STREAM_NOT_FOUND
      r
    case software.amazon.awssdk.services.qldb.model.ErrorCause.IAM_PERMISSION_REVOKED =>
      val r = IAM_PERMISSION_REVOKED
      r
  }
  case object unknownToSdkVersion extends zio.aws.qldb.model.ErrorCause {
    override def unwrap: software.amazon.awssdk.services.qldb.model.ErrorCause =
      software.amazon.awssdk.services.qldb.model.ErrorCause.UNKNOWN_TO_SDK_VERSION
  }
  case object KINESIS_STREAM_NOT_FOUND extends zio.aws.qldb.model.ErrorCause {
    override def unwrap: software.amazon.awssdk.services.qldb.model.ErrorCause =
      software.amazon.awssdk.services.qldb.model.ErrorCause.KINESIS_STREAM_NOT_FOUND
  }
  case object IAM_PERMISSION_REVOKED extends zio.aws.qldb.model.ErrorCause {
    override def unwrap: software.amazon.awssdk.services.qldb.model.ErrorCause =
      software.amazon.awssdk.services.qldb.model.ErrorCause.IAM_PERMISSION_REVOKED
  }
}
